/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.extensions.OreGrowthBlockState;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class OreGrowthRecipeManager {
    private static final OreGrowthRecipeManager SERVER = new OreGrowthRecipeManager();
    private static final OreGrowthRecipeManager CLIENT = new OreGrowthRecipeManager();
    private class_1863 recipeManager;
    private class_7225.class_7226<class_2248> blockLookup;
    private boolean reload = true;
    private Map<class_2248, OreGrowthRecipe> recipesByBlock = Collections.emptyMap();

    public static OreGrowthRecipeManager get(boolean isClient) {
        return isClient ? CLIENT : SERVER;
    }

    public synchronized void reloadRecipes(class_1863 recipeManager) {
        this.recipeManager = recipeManager;
        this.blockLookup = class_7923.field_41175;
        this.reload = true;
        this.recipesByBlock = Collections.emptyMap();
        for (class_2680 state : class_2248.field_10651) {
            ((OreGrowthBlockState)state).oreGrowthInvalidate();
        }
    }

    public OreGrowthRecipe getRecipeFor(class_2248 block) {
        this.cacheRecipes();
        return this.recipesByBlock.get(block);
    }

    public List<OreGrowthRecipe> getAllRecipes() {
        this.cacheRecipes();
        return Arrays.asList((OreGrowthRecipe[])this.recipesByBlock.values().toArray(OreGrowthRecipe[]::new));
    }

    private synchronized void cacheRecipes() {
        if (this.reload && this.recipeManager != null) {
            this.cacheRecipes(this.recipeManager.field_54638.method_64698(OreGrowth.ORE_GROWTH_RECIPE_TYPE).stream().sorted(Comparator.comparing(holder -> holder.comp_1932().toString())).map(class_8786::comp_1933));
        }
    }

    private synchronized void cacheRecipes(Stream<OreGrowthRecipe> recipes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        recipes.forEach(recipe -> recipe.bases(this.blockLookup).forEach(block -> builder.put(block, recipe)));
        this.recipesByBlock = builder.buildKeepingLast();
        this.reload = false;
    }

    public synchronized void setClientRecipes(Collection<OreGrowthRecipe> recipes) {
        if (this != CLIENT) {
            throw new IllegalStateException("Recipes must only be set directly on the client!");
        }
        this.cacheRecipes(recipes.stream());
    }
}

