/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.oregrowth.OreGrowthClient;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.JadeIds;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;

@WailaPlugin
public class OreGrowthWailaPlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        super.register(registration);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Direction facing = (Direction)accessor.getBlockState().getValue(OreGrowthBlock.FACE);
                Block base = accessor.getLevel().getBlockState(accessor.getPosition().relative(facing)).getBlock();
                tooltip.remove(JadeIds.CORE_OBJECT_NAME);
                tooltip.add(0, (Component)IThemeHelper.get().title((Object)TextComponents.translation((String)"oregrowth.ore_growth_block.adjusted_name", (Object[])new Object[]{base.getName()}).get()));
                OreGrowthRecipe recipe = OreGrowthRecipeManager.get(true).getRecipeFor(base);
                if (recipe != null) {
                    float growth = (float)((Integer)accessor.getBlockState().getValue((Property)OreGrowthBlock.STAGE)).intValue() / (float)recipe.stages() * 100.0f;
                    MutableComponent growthText = TextComponents.string((String)String.format("%.0f%%", Float.valueOf(growth))).color(growth < 100.0f ? ChatFormatting.WHITE : ChatFormatting.GREEN).get();
                    tooltip.add((Component)TextComponents.translation((String)"oregrowth.ore_growth_block.growth_hint", (Object[])new Object[]{growthText}).get());
                }
            }

            public ResourceLocation getUid() {
                return ResourceLocation.fromNamespaceAndPath((String)"oregrowth", (String)"ore_growth_hint");
            }
        }, OreGrowthBlock.class);
        registration.registerBlockIcon((IComponentProvider)new IBlockComponentProvider(this){

            public Element getIcon(BlockAccessor accessor, IPluginConfig config, final Element currentIcon) {
                BlockState state = accessor.getBlockState();
                Direction facing = (Direction)state.getValue(OreGrowthBlock.FACE);
                final Block base = accessor.getLevel().getBlockState(accessor.getPosition().relative(facing)).getBlock();
                return new Element(this){
                    {
                        this.width = currentIcon.getWidth();
                        this.height = currentIcon.getHeight();
                    }

                    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                        currentIcon.setX(this.getX());
                        currentIcon.setY(this.getY());
                        OreGrowthClient.itemModel.withContext(base, () -> currentIcon.render(guiGraphics, mouseX, mouseY, partialTicks));
                    }

                    @Nullable
                    public Component getNarration() {
                        return currentIcon.getNarration();
                    }
                };
            }

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            }

            public ResourceLocation getUid() {
                return ResourceLocation.fromNamespaceAndPath((String)"oregrowth", (String)"ore_growth_icon");
            }
        }, OreGrowthBlock.class);
    }
}

