/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat.rei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.compat.rei.OreGrowthREIDisplay;
import com.supermartijn642.oregrowth.compat.rei.OreGrowthREIPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.EmptyBlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class OreGrowthREIRecipeCategory
implements DisplayCategory<OreGrowthREIDisplay> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"oregrowth", (String)"screen/jei_category_background");

    public CategoryIdentifier<? extends OreGrowthREIDisplay> getCategoryIdentifier() {
        return OreGrowthREIPlugin.ORE_GROWTH_CATEGORY;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"oregrowth.jei_category.title").get();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)OreGrowth.ORE_GROWTH_ITEM);
    }

    public int getDisplayWidth(OreGrowthREIDisplay display) {
        return 121;
    }

    public int getDisplayHeight() {
        return 66;
    }

    public List<Widget> setupDisplay(OreGrowthREIDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int startX = bounds.x + 5;
        int startY = bounds.y + 5;
        OreGrowthRecipe recipe = display.getRecipe();
        int outputs = Math.min(recipe.getRecipeViewerDrops().size(), 6);
        int columns = outputs > 1 ? 2 : 1;
        int rows = (outputs + 1) / 2;
        for (int i = 0; i < outputs; ++i) {
            OreGrowthRecipe.RecipeViewerDrop drop = recipe.getRecipeViewerDrops().get(i);
            int x = 93 - columns * 9 + i % columns * 18;
            int y = 29 - rows * 9 + i / columns * 18;
            ArrayList<Object> tooltips = new ArrayList<Object>(3);
            tooltips.add(TextComponents.empty().get());
            MutableComponent minGrowth = TextComponents.number((int)((int)Math.round((double)drop.minStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            MutableComponent maxGrowth = TextComponents.number((int)((int)Math.round((double)drop.maxStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            if (drop.maxStage() > 1 || drop.maxStage() < recipe.stages()) {
                if (drop.minStage() == drop.maxStage()) {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth", (Object[])new Object[]{minGrowth}).get());
                } else {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth.range", (Object[])new Object[]{minGrowth, maxGrowth}).get());
                }
            }
            if (drop.chance() < 1.0) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.chance", (Object[])new Object[]{TextComponents.number((double)(drop.chance() * 100.0)).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get()}).get());
            }
            if (!drop.tooltip().isEmpty()) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.conditions").get());
                tooltips.addAll(drop.tooltip());
            }
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + x, startY + y)).entries(List.of(EntryStacks.of((ItemStack)drop.result()).tooltip(tooltips))).markOutput());
        }
        if (outputs <= 1) {
            startX += 9;
        }
        widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(startX + 37, startY + 20, 32, 15), (graphics, bounds1, mouseX, mouseY, delta) -> {
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)bounds1.x, (float)bounds1.y);
            graphics.blit(BACKGROUND, 0, 0, 111, 0, 32.0f, 15.0f, 256.0f, 256.0f);
            graphics.pose().popMatrix();
        }));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + 43, startY + 18)).entry(EntryStacks.of((ItemLike)Items.DIAMOND_PICKAXE)).notInteractable().disableBackground().disableHighlight().disableTooltips());
        final Function<EntryStack, Block> baseGetter = entry -> Optional.ofNullable(entry).map(EntryStack::getValue).map(ItemStack::getItem).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).getBlock()).orElse(null);
        Slot baseSlot = Widgets.createSlot((Rectangle)new Rectangle(startX + 2, startY + 24, 30, 30)).entries(recipe.bases((HolderLookup.RegistryLookup<Block>)BuiltInRegistries.BLOCK).stream().map(EntryStacks::of).map(entry -> {
            final EntryRenderer originalRenderer = entry.getRenderer();
            return entry.withRenderer((EntryRenderer)new EntryRenderer<ItemStack>(this){

                public void render(EntryStack<ItemStack> entry, GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    Block base = (Block)baseGetter.apply(entry);
                    if (base != null) {
                        graphics.pose().pushMatrix();
                        graphics.pose().translate((float)bounds.x, (float)bounds.y);
                        GuiGraphicsHelper.of((GuiGraphics)graphics).submitCustomRendering(22, 39, 40, 40, poseStack -> OreGrowthREIRecipeCategory.renderModel(poseStack, base.defaultBlockState(), 19, 14, 0));
                        graphics.pose().popMatrix();
                    }
                }

                @Nullable
                public Tooltip getTooltip(EntryStack<ItemStack> entry, TooltipContext context) {
                    return originalRenderer.getTooltip(entry, context);
                }
            });
        }).toList()).disableBackground().markInput();
        widgets.add((Widget)baseSlot);
        widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(startX + 2, startY + 8, 30, 30), (graphics, bounds1, mouseX, mouseY, delta) -> {
            Block base = (Block)baseGetter.apply(baseSlot.getCurrentEntry().cast());
            if (base != null) {
                graphics.pose().pushMatrix();
                graphics.pose().translate((float)bounds1.x, (float)bounds1.y);
                int stage = (int)(System.currentTimeMillis() / 1200L % (long)recipe.stages() + 1L);
                BlockState state = (BlockState)OreGrowth.ORE_GROWTH_BLOCK.defaultBlockState().setValue((Property)OreGrowthBlock.STAGE, (Comparable)Integer.valueOf(stage));
                BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
                if (model instanceof OreGrowthBlockBakedModel) {
                    GuiGraphicsHelper.of((GuiGraphics)graphics).submitCustomRendering(20, 15, 40, 40, poseStack -> ((OreGrowthBlockBakedModel)model).withContext(base, () -> OreGrowthREIRecipeCategory.renderModel(poseStack, state, 20, 15, 10)));
                } else {
                    GuiGraphicsHelper.of((GuiGraphics)graphics).submitCustomRendering(20, 15, 40, 40, poseStack -> OreGrowthREIRecipeCategory.renderModel(poseStack, state, 20, 15, 10));
                }
                graphics.pose().popMatrix();
            }
        }));
        return widgets;
    }

    private static void renderModel(PoseStack poseStack, BlockState state, int x, int y, int offset) {
        poseStack.translate((float)(x + 21), (float)(y + 16), (float)(150 + offset));
        poseStack.scale(1.85f, 1.85f, 1.85f);
        poseStack.scale(16.0f, -16.0f, 16.0f);
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationXYZ(0.5235988f, 3.9269907f, 0.0f));
        poseStack.scale(0.625f, 0.625f, 0.625f);
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (MultiBufferSource)RenderUtils.getMainBufferSource(), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (BlockAndTintGetter)EmptyBlockAndTintGetter.INSTANCE, (BlockPos)BlockPos.ZERO, (BlockState)state);
    }
}

