/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.OreGrowthConfig;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlock
extends BaseBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_STAGES = 4;
    public static IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)1, (int)4);
    public static EnumProperty<Direction> FACE = BlockStateProperties.FACING;
    public static BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final BlockShape[] SHAPES = new BlockShape[]{BlockShape.createBlockShape((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), BlockShape.createBlockShape((double)5.8, (double)0.0, (double)5.8, (double)10.2, (double)7.0, (double)10.2), BlockShape.createBlockShape((double)5.2, (double)0.0, (double)5.2, (double)10.8, (double)9.0, (double)10.8), BlockShape.createBlockShape((double)5.1, (double)0.0, (double)5.1, (double)10.9, (double)11.0, (double)10.9)};
    private static final BlockShape[] SHAPES_ROTATED = new BlockShape[SHAPES.length * 6];

    public static void trySpawnOreGrowth(OreGrowthRecipe recipe, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((double)random.nextFloat() > recipe.spawnChance() * OreGrowthConfig.spawnChanceScalar.get()) {
            return;
        }
        Direction side = Direction.values()[random.nextInt(Direction.values().length)];
        BlockPos growthPos = pos.relative(side);
        BlockState currentState = level.getBlockState(growthPos);
        if (!currentState.isAir() && !currentState.is(Blocks.WATER)) {
            return;
        }
        level.setBlockAndUpdate(growthPos, (BlockState)((BlockState)OreGrowth.ORE_GROWTH_BLOCK.defaultBlockState().setValue(FACE, (Comparable)side.getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(currentState.getFluidState().getType() == Fluids.WATER)));
    }

    public OreGrowthBlock() {
        super(false, BlockProperties.create().noLootTable().randomTicks().destroyTime(0.5f).explosionResistance(0.5f).sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(1))).setValue(FACE, (Comparable)Direction.DOWN)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Block base = level.getBlockState(pos.relative((Direction)state.getValue(FACE))).getBlock();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.isClientSide).getRecipeFor(base);
        if (recipe == null) {
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            return;
        }
        int stage = (Integer)state.getValue((Property)STAGE);
        if (stage < recipe.stages() && (double)random.nextFloat() < recipe.growthChance() * OreGrowthConfig.growthChanceScalar.get()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ServerLevel level = builder.getLevel();
        if (level == null) {
            return Collections.emptyList();
        }
        Vec3 origin = (Vec3)builder.getParameter(LootContextParams.ORIGIN);
        BlockPos pos = new BlockPos((int)Math.floor(origin.x), (int)Math.floor(origin.y), (int)Math.floor(origin.z));
        Direction facing = (Direction)state.getValue(FACE);
        BlockState base = level.getBlockState(pos.relative(facing));
        Entity entity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (entity instanceof Player ? !((Player)entity).hasCorrectToolForDrops(base, (Level)level, pos) : (entity instanceof LivingEntity ? !((LivingEntity)entity).getMainHandItem().isCorrectToolForDrops(base) : base.requiresCorrectToolForDrops())) {
            return Collections.emptyList();
        }
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.isClientSide).getRecipeFor(base.getBlock());
        if (recipe == null) {
            return Collections.emptyList();
        }
        LootParams lootParams = builder.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        return recipe.generateDrops(state, (Integer)state.getValue((Property)STAGE), lootParams);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        pos = pos.relative((Direction)state.getValue(FACE));
        return level.getBlockState(pos).getDestroyProgress(player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        Direction facing = (Direction)state.getValue(FACE);
        Block base = level.getBlockState(pos.relative(facing)).getBlock();
        return base.getSoundType(state, level, pos, entity);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Block base = level.getBlockState(pos.relative((Direction)state.getValue(FACE))).getBlock();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.isClientSide).getRecipeFor(base);
        if (recipe == null) {
            return 0;
        }
        int stage = (Integer)state.getValue((Property)STAGE);
        return (int)Math.floor((double)stage / (double)recipe.stages() * 15.0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES_ROTATED[((Integer)state.getValue((Property)STAGE) - 1) * 6 + ((Direction)state.getValue(FACE)).ordinal()].getUnderlying();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAGE, FACE, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        return this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos()) ? state : null;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!this.canSurvive(state, level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACE);
        return OreGrowthRecipeManager.get(level.isClientSide()).getRecipeFor(level.getBlockState(pos.relative(facing)).getBlock()) != null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    static {
        for (int stage = 0; stage < 4; ++stage) {
            BlockShape shape = SHAPES[stage];
            for (Direction face : Direction.values()) {
                OreGrowthBlock.SHAPES_ROTATED[stage * 6 + face.ordinal()] = face == Direction.UP ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X) : (face == Direction.NORTH ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y) : (face == Direction.EAST ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y) : (face == Direction.SOUTH ? shape.rotate(Direction.Axis.X) : (face == Direction.WEST ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y) : shape))));
            }
        }
    }
}

