/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.oregrowth.OreGrowthClient;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class OreGrowthBlockItemModel
implements ItemModel {
    private final RandomSource random = RandomSource.create();
    private final List<ItemTintSource> tints;
    private final Supplier<Vector3f[]> extents;
    private final ModelRenderProperties properties;

    public OreGrowthBlockItemModel(BlockModelWrapper original) {
        this.tints = original.tints;
        this.extents = original.extents;
        this.properties = original.properties;
    }

    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver modelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int k) {
        renderState.appendModelIdentityElement((Object)this);
        ItemStackRenderState.LayerRenderState layer = renderState.newLayer();
        if (stack.hasFoil()) {
            layer.setFoilType(ItemStackRenderState.FoilType.STANDARD);
            renderState.appendModelIdentityElement((Object)ItemStackRenderState.FoilType.STANDARD);
        }
        int tintCount = this.tints.size();
        int[] tints = layer.prepareTintLayers(tintCount);
        for (int i = 0; i < tintCount; ++i) {
            int tint;
            tints[i] = tint = this.tints.get(i).calculate(stack, level, entity);
            renderState.appendModelIdentityElement((Object)tint);
        }
        layer.setExtents(this.extents);
        layer.setRenderType(ItemBlockRenderTypes.getRenderType((ItemStack)stack));
        this.properties.applyToLayer(layer, displayContext);
        OreGrowthClient.itemModel.collectParts(this.random).stream().flatMap(part -> Arrays.stream(OreGrowthBlockBakedModel.MODEL_DIRECTIONS).map(arg_0 -> ((BlockModelPart)part).getQuads(arg_0))).flatMap(Collection::stream).forEach(layer.prepareQuadList()::add);
        Block base = OreGrowthClient.itemModel.getItemBaseBlockContext();
        if (base != null) {
            renderState.appendModelIdentityElement((Object)base);
        }
    }
}

