/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.codec.CodecHelper;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Either;
import com.supermartijn642.oregrowth.LootTableHelper;
import com.supermartijn642.oregrowth.OreGrowth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;

public class OreGrowthRecipe
implements Recipe<RecipeInput> {
    public static final RecipeSerializer<OreGrowthRecipe> SERIALIZER = new Serializer();
    private final List<Either<Block, TagKey<Block>>> bases;
    private List<Block> resolvedBases;
    private final int stages;
    private final double spawnChance;
    private final double growthChance;
    private final List<OreGrowthDrop> drops;
    private List<RecipeViewerDrop> resolvedDrops;

    private OreGrowthRecipe(List<Either<Block, TagKey<Block>>> bases, int stages, double spawnChance, double growthChance, List<OreGrowthDrop> drops) {
        this.bases = Collections.unmodifiableList(bases);
        this.stages = stages;
        this.spawnChance = spawnChance;
        this.growthChance = growthChance;
        this.drops = Collections.unmodifiableList(drops);
    }

    public List<Block> bases(HolderLookup.RegistryLookup<Block> blockLookup) {
        if (this.resolvedBases == null) {
            this.resolvedBases = this.bases.stream().flatMap(base -> base.isLeft() ? Stream.of((Block)base.left()) : blockLookup.get((TagKey)base.right()).map(tag -> tag.stream().map(Holder::value)).orElseGet(() -> Stream.of(new Block[0]))).toList();
        }
        return this.resolvedBases;
    }

    public int stages() {
        return this.stages;
    }

    public double spawnChance() {
        return this.spawnChance;
    }

    public double growthChance() {
        return this.growthChance;
    }

    public List<ItemStack> generateDrops(BlockState base, int stage, LootParams context) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (OreGrowthDrop drop : this.drops) {
            if (drop.minStage > stage || drop.maxStage < stage || drop.chance < 1.0 && context.getLevel().getRandom().nextDouble() > drop.chance) continue;
            if (drop.result.isLeft()) {
                drops.add(((ItemStack)drop.result.left()).copy());
                continue;
            }
            context.getLevel().getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.LOOT_TABLE, (ResourceLocation)((ResourceLocation)drop.result.right()))).getRandomItems(context, drops::add);
        }
        return drops;
    }

    public List<RecipeViewerDrop> getRecipeViewerDrops() {
        if (this.resolvedDrops == null) {
            if (!CommonUtils.getEnvironmentSide().isClient() && ClientUtils.getMinecraft().getSingleplayerServer() == null) {
                throw new IllegalStateException("Drops should have already been resolved when received from the server!");
            }
            this.resolveDrops(identifier -> CommonUtils.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.LOOT_TABLE, (ResourceLocation)identifier)));
        }
        return this.resolvedDrops;
    }

    public void resolveDrops(Function<ResourceLocation, LootTable> lookup) {
        if (this.resolvedDrops == null) {
            this.resolvedDrops = this.drops.stream().flatMap(drop -> (Stream)drop.result.flatMap(stack -> Stream.of(new RecipeViewerDrop(drop.minStage, drop.maxStage, drop.chance, (ItemStack)stack, List.of())), loot -> LootTableHelper.entriesInTable(loot, lookup).stream().map(entry -> new RecipeViewerDrop(drop.minStage, drop.maxStage, drop.chance * entry.chance(), entry.stack(), entry.conditions().stream().map(LootTableHelper.LootEntryConditions::toComponents).flatMap(Collection::stream).toList())))).sorted(Comparator.comparing(RecipeViewerDrop::maxStage, Comparator.reverseOrder()).thenComparing(RecipeViewerDrop::minStage, Comparator.reverseOrder()).thenComparing(RecipeViewerDrop::chance, Comparator.reverseOrder())).toList();
        }
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(RecipeInput input, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<OreGrowthRecipe> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<OreGrowthRecipe> getType() {
        return OreGrowth.ORE_GROWTH_RECIPE_TYPE;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "oregrowth:ore_growth");
        if (this.bases.size() == 1) {
            json.addProperty("base", (String)this.bases.get(0).flatMap(block -> Registries.BLOCKS.getIdentifier(block).toString(), tag -> "#" + String.valueOf(tag.location())));
        } else {
            JsonArray bases = new JsonArray(this.bases.size());
            this.bases.stream().map(base -> (String)base.flatMap(block -> Registries.BLOCKS.getIdentifier(block).toString(), tag -> "#" + String.valueOf(tag.location()))).forEach(arg_0 -> ((JsonArray)bases).add(arg_0));
            json.add("base", (JsonElement)bases);
        }
        json.addProperty("stages", (Number)this.stages);
        json.addProperty("spawn_chance", (Number)this.spawnChance);
        json.addProperty("growth_chance", (Number)this.growthChance);
        JsonArray dropsArray = new JsonArray(this.drops.size());
        this.drops.forEach(drop -> dropsArray.add((JsonElement)drop.toJson()));
        json.add("drops", (JsonElement)dropsArray);
        return json;
    }

    public static OreGrowthRecipe fromJson(JsonObject json) {
        JsonArray basesJson;
        if (!(json.has("base") && (json.get("base").isJsonPrimitive() && json.getAsJsonPrimitive("base").isString() || json.get("base").isJsonArray()))) {
            throw new JsonParseException("Recipe must have array property 'base'!");
        }
        if (json.get("base").isJsonPrimitive()) {
            basesJson = new JsonArray(1);
            basesJson.add(json.get("base").getAsString());
        } else {
            basesJson = json.getAsJsonArray("base");
        }
        HashSet<Either> bases = new HashSet<Either>(basesJson.size());
        for (JsonElement baseJson : basesJson) {
            if (!baseJson.isJsonPrimitive() || !baseJson.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'base' must only contain strings!");
            }
            String baseIdentifier = baseJson.getAsString();
            if (baseIdentifier.charAt(0) == '#') {
                if (!RegistryUtil.isValidIdentifier((String)(baseIdentifier = baseIdentifier.substring(1)))) {
                    throw new JsonParseException("Property 'base' must be a valid identifier, not '" + baseIdentifier + "'!");
                }
                bases.add(Either.right((Object)TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)baseIdentifier))));
                continue;
            }
            if (!RegistryUtil.isValidIdentifier((String)baseIdentifier)) {
                throw new JsonParseException("Property 'base' must be a valid identifier, not '" + baseIdentifier + "'!");
            }
            if (!Registries.BLOCKS.hasIdentifier(ResourceLocation.parse((String)baseIdentifier))) {
                throw new JsonParseException("Unknown base block '" + baseIdentifier + "'!");
            }
            Block block = (Block)Registries.BLOCKS.getValue(ResourceLocation.parse((String)baseIdentifier));
            if (block == Blocks.AIR || block == Blocks.CAVE_AIR || block == Blocks.VOID_AIR) {
                throw new JsonParseException("Got AIR block for base identifier '" + baseIdentifier + "'!");
            }
            bases.add(Either.left((Object)block));
        }
        if (!(json.has("stages") && json.get("stages").isJsonPrimitive() && json.getAsJsonPrimitive("stages").isNumber())) {
            throw new JsonParseException("Recipe must have int property 'stages'!");
        }
        int stages = json.get("stages").getAsInt();
        if (stages < 1 || stages > 4) {
            throw new JsonParseException("Invalid number of stages: '" + stages + "'!");
        }
        if (!(json.has("spawn_chance") && json.get("spawn_chance").isJsonPrimitive() && json.getAsJsonPrimitive("spawn_chance").isNumber())) {
            throw new JsonParseException("Recipe must have number property 'spawn_chance'!");
        }
        double spawnChance = json.get("spawn_chance").getAsDouble();
        if (spawnChance <= 0.0 || spawnChance > 1.0) {
            throw new JsonParseException("Invalid spawn chance: '" + spawnChance + "'!");
        }
        if (!(json.has("growth_chance") && json.get("growth_chance").isJsonPrimitive() && json.getAsJsonPrimitive("growth_chance").isNumber())) {
            throw new JsonParseException("Recipe must have number property 'growth_chance'!");
        }
        double growthChance = json.get("growth_chance").getAsDouble();
        if (growthChance <= 0.0 || growthChance > 1.0) {
            throw new JsonParseException("Invalid growth chance: '" + growthChance + "'!");
        }
        ArrayList<OreGrowthDrop> drops = new ArrayList<OreGrowthDrop>();
        if (json.has("result")) {
            if (!json.get("result").isJsonObject()) {
                throw new JsonParseException("Property 'result' must be an object!");
            }
            JsonObject resultJson = json.getAsJsonObject("result");
            if (!((resultJson.has("item") && resultJson.get("item").isJsonPrimitive() && resultJson.getAsJsonPrimitive("item").isString() || resultJson.has("id") && resultJson.get("id").isJsonPrimitive() && resultJson.getAsJsonPrimitive("id").isString()) && resultJson.has("count") && resultJson.get("count").isJsonPrimitive() && resultJson.getAsJsonPrimitive("count").isNumber())) {
                throw new JsonParseException("Property 'result' must have string property 'item' and int property 'count'!");
            }
            if (resultJson.has("item") && resultJson.has("id")) {
                throw new JsonParseException("Property 'result' can only have either string property 'item' or string property 'id', not both!");
            }
            if (resultJson.has("item") && !RegistryUtil.isValidIdentifier((String)resultJson.get("item").getAsString())) {
                throw new JsonParseException("Drop property 'item' must be a valid identifier, not '" + resultJson.get("item").getAsString() + "'!");
            }
            if (resultJson.has("id") && !RegistryUtil.isValidIdentifier((String)resultJson.get("id").getAsString())) {
                throw new JsonParseException("Drop property 'id' must be a valid identifier, not '" + resultJson.get("id").getAsString() + "'!");
            }
            ResourceLocation id = ResourceLocation.parse((String)(resultJson.has("item") ? resultJson.get("item").getAsString() : resultJson.get("id").getAsString()));
            if (!Registries.ITEMS.hasIdentifier(id)) {
                throw new JsonParseException("Unknown item '" + String.valueOf(id) + "'!");
            }
            Item item = (Item)Registries.ITEMS.getValue(id);
            int count = resultJson.get("count").getAsInt();
            if (count < 1) {
                throw new JsonParseException("Drop property 'count' must be a positive integer!");
            }
            drops.add(new OreGrowthDrop(stages, stages, 1.0, (Either<ItemStack, ResourceLocation>)Either.left((Object)new ItemStack((ItemLike)item, count))));
        } else {
            if (!json.has("drops") || !json.get("drops").isJsonArray()) {
                throw new JsonParseException("Recipe must have array property 'drops'!");
            }
            JsonArray dropsArray = json.getAsJsonArray("drops");
            if (dropsArray.size() == 0) {
                throw new JsonParseException("Property 'drops' must have at least one entry!");
            }
            for (JsonElement el : dropsArray) {
                if (!el.isJsonObject()) {
                    throw new JsonParseException("Drop property 'drops' must only contain objects!");
                }
                drops.add(OreGrowthDrop.fromJson(el.getAsJsonObject()));
            }
        }
        return new OreGrowthRecipe(new ArrayList<Either<Block, TagKey<Block>>>(bases), stages, spawnChance, growthChance, drops);
    }

    public record OreGrowthDrop(int minStage, int maxStage, double chance, Either<ItemStack, ResourceLocation> result) {
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            if (this.minStage == this.maxStage) {
                json.addProperty("stage", (Number)this.minStage);
            } else {
                json.addProperty("min_stage", (Number)this.minStage);
                json.addProperty("max_stage", (Number)this.maxStage);
            }
            json.addProperty("chance", (Number)this.chance);
            this.result.ifLeft(stack -> {
                JsonObject resultJson = new JsonObject();
                resultJson.addProperty("id", Registries.ITEMS.getIdentifier((Object)stack.getItem()).toString());
                resultJson.addProperty("count", (Number)stack.getCount());
                json.add("item", (JsonElement)resultJson);
            });
            this.result.ifRight(lootTable -> json.addProperty("loot_table", lootTable.toString()));
            return json;
        }

        public static OreGrowthDrop fromJson(JsonObject json) {
            Either result;
            double chance;
            int minStage;
            int maxStage;
            if (!(json.has("min_stage") && json.has("max_stage") || json.has("stage"))) {
                throw new JsonParseException("Drop must either have int properties 'min_stage' and 'max_stage', or have int property 'stage'!");
            }
            if ((json.has("min_stage") || json.has("max_stage")) && json.has("stage")) {
                throw new JsonParseException("Drop must have int properties 'min_stage' and 'max_stage', or int property 'stage', not both!");
            }
            if (json.has("stage")) {
                if (!json.get("stage").isJsonPrimitive() || !json.getAsJsonPrimitive("stage").isNumber()) {
                    throw new JsonParseException("Drop property 'stage' must be an integer!");
                }
                int stage = json.get("stage").getAsInt();
                if (stage < 1 || stage > 4) {
                    throw new JsonParseException("Drop property 'stage' must be between 1 and 4!");
                }
                minStage = maxStage = stage;
            } else {
                if (!(json.has("min_stage") && json.get("min_stage").isJsonPrimitive() && json.getAsJsonPrimitive("min_stage").isNumber())) {
                    throw new JsonParseException("Drop must have int property 'min_stage'!");
                }
                minStage = json.get("min_stage").getAsInt();
                if (minStage < 1 || minStage > 4) {
                    throw new JsonParseException("Drop property 'min_stage' must be between 1 and 4!");
                }
                if (!(json.has("max_stage") && json.get("max_stage").isJsonPrimitive() && json.getAsJsonPrimitive("max_stage").isNumber())) {
                    throw new JsonParseException("Drop must have int property 'max_stage'!");
                }
                maxStage = json.get("max_stage").getAsInt();
                if (maxStage < 1 || maxStage > 4) {
                    throw new JsonParseException("Drop property 'maxStage' must be between 1 and 4!");
                }
                if (minStage > maxStage) {
                    throw new JsonParseException("Drop property 'min_stage' must be less than 'max_stage'!");
                }
            }
            if (!(!json.has("chance") || json.get("chance").isJsonPrimitive() && json.getAsJsonPrimitive("chance").isNumber())) {
                throw new JsonParseException("Drop property 'chance' must be a number!");
            }
            double d = chance = json.has("chance") ? json.get("chance").getAsDouble() : 1.0;
            if (chance < 0.0 || chance > 1.0) {
                throw new JsonParseException("Drop property 'chance' must be between 0 and 1!");
            }
            if (!json.has("item") && !json.has("loot_table")) {
                throw new JsonParseException("Drop must have either object property 'item' or string property 'loot_table'!");
            }
            if (json.has("item") && json.has("loot_table")) {
                throw new JsonParseException("Drop can only have either 'item' or 'loot_table', not both!");
            }
            if (json.has("item")) {
                if (!json.get("item").isJsonObject()) {
                    throw new JsonParseException("Drop property 'item' must be an object!");
                }
                JsonObject resultJson = json.getAsJsonObject("item");
                if (!(resultJson.has("id") && resultJson.get("id").isJsonPrimitive() && resultJson.getAsJsonPrimitive("id").isString() && resultJson.has("count") && resultJson.get("count").isJsonPrimitive() && resultJson.getAsJsonPrimitive("count").isNumber())) {
                    throw new JsonParseException("Drop property 'item' must have string property 'id' and int property 'count'!");
                }
                if (!RegistryUtil.isValidIdentifier((String)resultJson.get("id").getAsString())) {
                    throw new JsonParseException("Drop property 'id' must be a valid identifier, not '" + resultJson.get("id").getAsString() + "'!");
                }
                ResourceLocation id = ResourceLocation.parse((String)resultJson.get("id").getAsString());
                if (!Registries.ITEMS.hasIdentifier(id)) {
                    throw new JsonParseException("Unknown item '" + String.valueOf(id) + "'!");
                }
                Item item = (Item)Registries.ITEMS.getValue(id);
                int count = resultJson.get("count").getAsInt();
                if (count < 1) {
                    throw new JsonParseException("Drop property 'count' must be a positive integer!");
                }
                result = Either.left((Object)new ItemStack((ItemLike)item, count));
            } else {
                if (!json.get("loot_table").isJsonPrimitive() || !json.getAsJsonPrimitive("loot_table").isString()) {
                    throw new JsonParseException("Drop property 'loot_table' must be a string!");
                }
                if (!RegistryUtil.isValidIdentifier((String)json.get("loot_table").getAsString())) {
                    throw new JsonParseException("Drop property 'loot_table' must be a valid identifier, not '" + json.get("loot_table").getAsString() + "'!");
                }
                result = Either.right((Object)ResourceLocation.parse((String)json.get("loot_table").getAsString()));
            }
            return new OreGrowthDrop(minStage, maxStage, chance, (Either<ItemStack, ResourceLocation>)result);
        }
    }

    public record RecipeViewerDrop(int minStage, int maxStage, double chance, ItemStack result, List<? extends Component> tooltip) {
    }

    private static class Serializer
    implements RecipeSerializer<OreGrowthRecipe> {
        private static final MapCodec<OreGrowthRecipe> CODEC = CodecHelper.jsonSerializerToMapCodec(OreGrowthRecipe::toJson, OreGrowthRecipe::fromJson);
        private static final StreamCodec<RegistryFriendlyByteBuf, OreGrowthRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        private Serializer() {
        }

        public MapCodec<OreGrowthRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, OreGrowthRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static OreGrowthRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            int baseCount = buffer.readInt();
            ArrayList<Either<Block, TagKey<Block>>> bases = new ArrayList<Either<Block, TagKey<Block>>>(baseCount);
            for (int i = 0; i < baseCount; ++i) {
                boolean isBlock = buffer.readBoolean();
                ResourceLocation baseIdentifier = buffer.readResourceLocation();
                if (isBlock) {
                    if (!Registries.BLOCKS.hasIdentifier(baseIdentifier)) {
                        throw new IllegalArgumentException("Unknown block '" + String.valueOf(baseIdentifier) + "'!");
                    }
                    Block block = (Block)Registries.BLOCKS.getValue(baseIdentifier);
                    if (block == Blocks.AIR || block == Blocks.CAVE_AIR || block == Blocks.VOID_AIR) {
                        throw new IllegalArgumentException("Got AIR block for identifier '" + String.valueOf(baseIdentifier) + "'!");
                    }
                    bases.add(Either.left((Object)block));
                    continue;
                }
                bases.add(Either.right((Object)TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)baseIdentifier)));
            }
            int stages = buffer.readInt();
            if (stages < 1 || stages > 4) {
                throw new IllegalArgumentException("Invalid number of stages: '" + stages + "'!");
            }
            double spawnChance = buffer.readDouble();
            if (spawnChance <= 0.0 || spawnChance > 1.0) {
                throw new IllegalArgumentException("Invalid spawn chance: '" + spawnChance + "'!");
            }
            double growthChance = buffer.readDouble();
            if (growthChance <= 0.0 || growthChance > 1.0) {
                throw new IllegalArgumentException("Invalid growth chance: '" + growthChance + "'!");
            }
            int dropCount = buffer.readInt();
            ArrayList<OreGrowthDrop> drops = new ArrayList<OreGrowthDrop>(dropCount);
            for (int i = 0; i < dropCount; ++i) {
                int minStage = buffer.readInt();
                int maxStage = buffer.readInt();
                double chance = buffer.readDouble();
                Either result = buffer.readBoolean() ? Either.left((Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer))) : Either.right((Object)buffer.readResourceLocation());
                drops.add(new OreGrowthDrop(minStage, maxStage, chance, (Either<ItemStack, ResourceLocation>)result));
            }
            int resolvedDropCount = buffer.readInt();
            ArrayList<RecipeViewerDrop> resolvedDrops = new ArrayList<RecipeViewerDrop>(resolvedDropCount);
            for (int i = 0; i < resolvedDropCount; ++i) {
                int minStage = buffer.readInt();
                int maxStage = buffer.readInt();
                double chance = buffer.readDouble();
                ItemStack result = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
                int tooltipCount = buffer.readInt();
                ArrayList<Component> tooltip = new ArrayList<Component>(tooltipCount);
                for (int j = 0; j < tooltipCount; ++j) {
                    tooltip.add((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buffer));
                }
                resolvedDrops.add(new RecipeViewerDrop(minStage, maxStage, chance, result, tooltip));
            }
            OreGrowthRecipe recipe = new OreGrowthRecipe(bases, stages, spawnChance, growthChance, drops);
            recipe.resolvedDrops = resolvedDrops;
            return recipe;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, OreGrowthRecipe recipe) {
            buffer.writeInt(recipe.bases.size());
            for (Either<Block, TagKey<Block>> either : recipe.bases) {
                buffer.writeBoolean(either.isLeft());
                buffer.writeResourceLocation((ResourceLocation)either.flatMap(arg_0 -> ((Registries.Registry)Registries.BLOCKS).getIdentifier(arg_0), TagKey::location));
            }
            buffer.writeInt(recipe.stages);
            buffer.writeDouble(recipe.spawnChance);
            buffer.writeDouble(recipe.growthChance);
            buffer.writeInt(recipe.drops.size());
            for (OreGrowthDrop oreGrowthDrop : recipe.drops) {
                buffer.writeInt(oreGrowthDrop.minStage);
                buffer.writeInt(oreGrowthDrop.maxStage);
                buffer.writeDouble(oreGrowthDrop.chance);
                buffer.writeBoolean(oreGrowthDrop.result.isLeft());
                oreGrowthDrop.result.ifLeft(item -> ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, item));
                oreGrowthDrop.result.ifRight(arg_0 -> ((RegistryFriendlyByteBuf)buffer).writeResourceLocation(arg_0));
            }
            if (CommonUtils.getServer() != null && CommonUtils.getServer().reloadableRegistries() != null) {
                recipe.resolveDrops(identifier -> CommonUtils.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.LOOT_TABLE, (ResourceLocation)identifier)));
            }
            if (recipe.resolvedDrops == null) {
                buffer.writeInt(0);
                return;
            }
            buffer.writeInt(recipe.resolvedDrops.size());
            for (RecipeViewerDrop recipeViewerDrop : recipe.resolvedDrops) {
                buffer.writeInt(recipeViewerDrop.minStage);
                buffer.writeInt(recipeViewerDrop.maxStage);
                buffer.writeDouble(recipeViewerDrop.chance);
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipeViewerDrop.result);
                buffer.writeInt(recipeViewerDrop.tooltip.size());
                for (Component component : recipeViewerDrop.tooltip) {
                    ComponentSerialization.STREAM_CODEC.encode((Object)buffer, (Object)component);
                }
            }
        }
    }
}

