/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.util.Triple;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableHelper {
    private static final Function<LootTable, List<LootPool>> lootTable$pools;

    public static List<LootEntry> entriesInTable(ResourceLocation tableIdentifier, Function<ResourceLocation, LootTable> lookup) {
        LootTable table = lookup.apply(tableIdentifier);
        ArrayList<LootEntry> items = new ArrayList();
        for (LootPool pool : lootTable$pools.apply(table)) {
            float rolls = LootTableHelper.averageValue(pool.f_79028_);
            int totalWeight = Arrays.stream(pool.f_79023_).mapToInt(LootTableHelper::containerWeight).sum();
            Arrays.stream(pool.f_79023_).flatMap(container -> LootTableHelper.itemsFromContainer(container, totalWeight, lookup)).map(entry -> entry.withChance(1.0 - Math.pow(1.0 - entry.chance, rolls))).forEach(items::add);
        }
        items = new ArrayList(items.stream().collect(Collectors.toMap(entry -> Triple.of((Object)entry.stack.m_41720_(), (Object)entry.stack.m_41783_(), (Object)Pair.of((Object)entry.stack.m_41613_(), entry.conditions)), Function.identity(), (first, second) -> first.withChance(1.0 - (1.0 - first.chance) * (1.0 - second.chance)))).values());
        return items;
    }

    private static int containerWeight(LootPoolEntryContainer container) {
        if (container instanceof LootPoolSingletonContainer) {
            return ((LootPoolSingletonContainer)container).f_79675_;
        }
        if (container instanceof AlternativesEntry) {
            return Arrays.stream(((AlternativesEntry)container).f_79428_).mapToInt(LootTableHelper::containerWeight).max().orElse(0);
        }
        if (container instanceof EntryGroup) {
            return Arrays.stream(((EntryGroup)container).f_79428_).mapToInt(LootTableHelper::containerWeight).sum();
        }
        if (container instanceof SequentialEntry) {
            return Arrays.stream(((SequentialEntry)container).f_79428_).mapToInt(LootTableHelper::containerWeight).sum();
        }
        return 1;
    }

    private static Stream<LootEntry> itemsFromContainer(LootPoolEntryContainer container, int totalWeight, Function<ResourceLocation, LootTable> lookup) {
        List<LootEntryConditions> conditions = Arrays.stream(container.f_79636_).map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
        if (container instanceof AlternativesEntry) {
            MutableComponent not = TextComponents.translation((String)"oregrowth.jei_category.conditions.none_of").get();
            LinkedHashSet previousConditions = new LinkedHashSet();
            ArrayList entries = new ArrayList();
            for (LootPoolEntryContainer child : ((AlternativesEntry)container).f_79428_) {
                Stream<LootEntry> stream = LootTableHelper.itemsFromContainer(child, totalWeight, lookup);
                if (!previousConditions.isEmpty()) {
                    stream = stream.map(entry -> entry.prependConditions(Stream.concat(conditions.stream(), Stream.of(new LootEntryConditions(not, new ArrayList<LootEntryConditions>(previousConditions)))), conditions.size() + 1));
                }
                stream.forEach(entries::add);
                Arrays.stream(child.f_79636_).map(LootTableHelper::formatCondition).filter(Objects::nonNull).forEach(previousConditions::add);
            }
            return entries.stream();
        }
        if (container instanceof EntryGroup) {
            return Arrays.stream(((EntryGroup)container).f_79428_).flatMap(c -> LootTableHelper.itemsFromContainer(c, totalWeight, lookup)).map(entry -> entry.prependConditions(conditions.stream(), conditions.size()));
        }
        if (container instanceof SequentialEntry) {
            LinkedHashSet previousConditions = new LinkedHashSet();
            return Arrays.stream(((SequentialEntry)container).f_79428_).flatMap(c -> LootTableHelper.itemsFromContainer(c, totalWeight, lookup)).map(entry -> {
                LootEntry newEntry = entry.prependConditions(Stream.concat(conditions.stream(), previousConditions.stream()), conditions.size() + previousConditions.size());
                previousConditions.addAll(entry.conditions);
                return newEntry;
            });
        }
        if (container instanceof LootItem) {
            return Stream.of(new LootEntry(new ItemStack((ItemLike)((LootItem)container).f_79564_), (double)((LootItem)container).f_79675_ / (double)totalWeight, conditions));
        }
        if (container instanceof LootTableReference) {
            return LootTableHelper.entriesInTable(((LootTableReference)container).f_79754_, lookup).stream().map(entry -> entry.withChance(entry.chance * (double)((LootTableReference)container).f_79675_ / (double)totalWeight).prependConditions(conditions.stream(), conditions.size()));
        }
        return Stream.empty();
    }

    private static LootEntryConditions formatCondition(LootItemCondition condition) {
        if (condition instanceof PredicateManager.CompositePredicate) {
            List<LootEntryConditions> subs = Arrays.stream(((PredicateManager.CompositePredicate)condition).f_79256_).map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
            if (subs.isEmpty()) {
                return null;
            }
            if (subs.size() == 1) {
                return subs.get(0);
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.all_of").get(), subs);
        }
        if (condition instanceof AlternativeLootItemCondition) {
            List<LootEntryConditions> subs = Arrays.stream(((AlternativeLootItemCondition)condition).f_81468_).map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
            if (subs.isEmpty()) {
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.never").get(), List.of());
            }
            if (subs.size() == 1) {
                return subs.get(0);
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.any_of").get(), subs);
        }
        if (condition instanceof InvertedLootItemCondition) {
            LootEntryConditions sub = LootTableHelper.formatCondition(((InvertedLootItemCondition)condition).f_81681_);
            if (sub == null) {
                return null;
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.not").get(), List.of(sub));
        }
        if (condition instanceof WeatherCheck) {
            if (((WeatherCheck)condition).f_82056_ != null) {
                if (((WeatherCheck)condition).f_82056_.booleanValue()) {
                    return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.raining").get(), List.of());
                }
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.raining.not").get(), List.of());
            }
            if (((WeatherCheck)condition).f_82057_ != null) {
                if (((WeatherCheck)condition).f_82057_.booleanValue()) {
                    return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.thundering").get(), List.of());
                }
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.thundering.not").get(), List.of());
            }
            return null;
        }
        if (condition instanceof MatchTool) {
            MutableComponent predicate = LootTableHelper.formatItemPredicate(((MatchTool)condition).f_81993_);
            if (predicate == null) {
                return null;
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool").append(predicate).get(), List.of());
        }
        return null;
    }

    private static MutableComponent formatItemPredicate(ItemPredicate predicate) {
        MutableComponent enchantments = null;
        if (predicate.f_45033_.length == 1) {
            enchantments = TextComponents.translation((String)predicate.f_45033_[0].f_30466_.m_44704_()).color(ChatFormatting.GOLD).get();
        } else if (predicate.f_45033_.length == 2) {
            MutableComponent enchant1 = TextComponents.translation((String)predicate.f_45033_[0].f_30466_.m_44704_()).color(ChatFormatting.GOLD).get();
            MutableComponent enchant2 = TextComponents.translation((String)predicate.f_45033_[1].f_30466_.m_44704_()).color(ChatFormatting.GOLD).get();
            enchantments = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.two_items", (Object[])new Object[]{enchant1, enchant2}).get();
        } else if (predicate.f_45033_.length > 2) {
            TextComponents.TextComponentBuilder builder = TextComponents.translation((String)predicate.f_45033_[0].f_30466_.m_44704_()).color(ChatFormatting.GOLD);
            for (int i = 1; i < predicate.f_45033_.length - 1; ++i) {
                builder = builder.string(", ").append(TextComponents.translation((String)predicate.f_45033_[i].f_30466_.m_44704_()).color(ChatFormatting.GOLD).get());
            }
            MutableComponent lastEnchant = TextComponents.translation((String)predicate.f_45033_[predicate.f_45033_.length - 1].f_30466_.m_44704_()).color(ChatFormatting.GOLD).get();
            enchantments = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.more_items", (Object[])new Object[]{builder.get(), lastEnchant}).get();
        }
        if (predicate.f_45029_ != null) {
            if (enchantments == null) {
                return TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.tag", (Object[])new Object[]{predicate.f_45029_.f_203868_()}).get();
            }
            return TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.tag", (Object[])new Object[]{predicate.f_45029_.f_203868_()}).translation("oregrowth.jei_category.conditions.match_tool.enchanted", new Object[]{enchantments}).get();
        }
        if (predicate.f_151427_ != null) {
            TextComponents.TextComponentBuilder itemsFormatted;
            if (predicate.f_151427_.isEmpty()) {
                return null;
            }
            List<TextComponents.TextComponentBuilder> items = predicate.f_151427_.stream().map(TextComponents::item).map(b -> b.color(ChatFormatting.GOLD)).sorted(Comparator.comparing(TextComponents.TextComponentBuilder::format)).toList();
            if (predicate.f_151427_.size() == 1) {
                itemsFormatted = items.get(0);
            } else if (predicate.f_151427_.size() == 2) {
                itemsFormatted = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.two_items", (Object[])new Object[]{items.get(0), items.get(1)});
            } else if (predicate.f_151427_.size() > 2) {
                TextComponents.TextComponentBuilder builder = items.get(0);
                for (int i = 1; i < predicate.f_151427_.size() - 1; ++i) {
                    builder = builder.string(", ").append(items.get(i).get());
                }
                itemsFormatted = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.more_items", (Object[])new Object[]{builder.get(), items.get(items.size() - 1)});
            } else {
                throw new AssertionError();
            }
            if (enchantments != null) {
                itemsFormatted = itemsFormatted.translation("oregrowth.jei_category.conditions.match_tool.enchanted", new Object[]{enchantments});
            }
            return itemsFormatted.get();
        }
        return enchantments;
    }

    private static float averageValue(NumberProvider provider) {
        if (provider instanceof BinomialDistributionGenerator) {
            return LootTableHelper.averageValue(((BinomialDistributionGenerator)provider).f_165653_) * LootTableHelper.averageValue(((BinomialDistributionGenerator)provider).f_165654_);
        }
        if (provider instanceof ConstantValue) {
            return ((ConstantValue)provider).f_165688_;
        }
        if (provider instanceof UniformGenerator) {
            return (LootTableHelper.averageValue(((UniformGenerator)provider).f_165774_) + LootTableHelper.averageValue(((UniformGenerator)provider).f_165775_)) / 2.0f;
        }
        return -1.0f;
    }

    static {
        try {
            Field field = LootTable.class.getDeclaredField("pools");
            field.setAccessible(true);
            lootTable$pools = lootTable -> {
                try {
                    return (List)field.get(lootTable);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to make 'LootTable#pools' field accessible!", e);
        }
    }

    public record LootEntry(ItemStack stack, double chance, Collection<LootEntryConditions> conditions) {
        LootEntry withChance(double chance) {
            return new LootEntry(this.stack, chance, this.conditions);
        }

        LootEntry prependConditions(Stream<LootEntryConditions> conditions, int count) {
            LinkedHashSet<LootEntryConditions> merged = new LinkedHashSet<LootEntryConditions>(this.conditions.size() + count);
            conditions.forEach(merged::add);
            merged.addAll(this.conditions);
            return new LootEntry(this.stack, this.chance, merged);
        }
    }

    public record LootEntryConditions(MutableComponent component, List<LootEntryConditions> subConditions) {
        public List<MutableComponent> toComponents() {
            if (this.subConditions.isEmpty()) {
                return List.of(TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet").append(this.component).get());
            }
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet").append(this.component).get());
            this.subConditions.stream().map(LootEntryConditions::toComponents).flatMap(Collection::stream).map(component -> TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet.spacing").append(component).get()).forEach(components::add);
            return components;
        }
    }
}

