/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import java.util.List;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementHorizontal;
import mcjty.theoneprobe.apiimpl.elements.ElementItemLabel;
import mcjty.theoneprobe.apiimpl.elements.ElementItemStack;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.elements.ElementVertical;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OreGrowthTOPPlugin
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public ResourceLocation getID() {
                return new ResourceLocation("oregrowth", "ore_growth_hint");
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState state, IProbeHitData hitData) {
                OreGrowthRecipe recipe;
                List elements;
                IElement element;
                if (!state.m_60713_((Block)OreGrowth.ORE_GROWTH_BLOCK)) {
                    return;
                }
                Direction facing = (Direction)state.m_61143_(OreGrowthBlock.FACE);
                Block base = level.m_8055_(hitData.getPos().m_142300_(facing)).m_60734_();
                if (probeInfo.getElements().size() > 0 && (element = (IElement)probeInfo.getElements().get(0)) instanceof ElementHorizontal && (elements = ((ElementHorizontal)element).getElements()).size() == 2) {
                    ElementVertical vertical;
                    Object e;
                    if (elements.get(0) instanceof ElementItemStack) {
                        ElementItemStack oldElement = (ElementItemStack)elements.remove(0);
                        elements.add(0, new WrappedItemStackElement(oldElement, probeInfo.defaultItemStyle(), base));
                    }
                    if ((e = elements.get(1)) instanceof ElementVertical && (vertical = (ElementVertical)e).getElements().get(0) instanceof ElementItemLabel) {
                        vertical.getElements().remove(0);
                        vertical.getElements().add(0, new ElementText((Component)TextComponents.translation((String)"oregrowth.ore_growth_block.adjusted_name", (Object[])new Object[]{base.m_49954_()}).get()));
                    }
                }
                if ((recipe = OreGrowthRecipeManager.get(false).getRecipeFor(base)) != null) {
                    float growth = (float)((Integer)state.m_61143_((Property)OreGrowthBlock.STAGE)).intValue() / (float)recipe.stages() * 100.0f;
                    MutableComponent growthText = TextComponents.string((String)(growth < 100.0f ? TextStyleClass.WARNING.toString() : TextStyleClass.OK.toString())).string(String.format("%.0f%%", Float.valueOf(growth))).get();
                    probeInfo.text((Component)TextComponents.string((String)TextStyleClass.LABEL.toString()).translation("oregrowth.ore_growth_block.growth_hint", new Object[]{growthText}).get());
                }
            }
        });
        theOneProbe.registerElementFactory(new IElementFactory(){

            public IElement createElement(FriendlyByteBuf buffer) {
                return new WrappedItemStackElement(buffer);
            }

            public ResourceLocation getId() {
                return new ResourceLocation("oregrowth", "ore_growth_icon");
            }
        });
        return null;
    }

    private static class WrappedItemStackElement
    extends ElementItemStack {
        private final ElementItemStack wrapped;
        private final Block base;

        public WrappedItemStackElement(ElementItemStack wrapped, IItemStyle itemStyle, Block base) {
            super(ItemStack.f_41583_, itemStyle);
            this.wrapped = wrapped;
            this.base = base;
        }

        public ResourceLocation getID() {
            return new ResourceLocation("oregrowth", "ore_growth_icon");
        }

        public WrappedItemStackElement(FriendlyByteBuf buf) {
            super(buf);
            this.wrapped = null;
            this.base = (Block)Registries.BLOCKS.getValue(buf.m_130281_());
            if (this.base == null) {
                throw new RuntimeException("Received invalid base block!");
            }
        }

        public void render(PoseStack poseStack, int x, int y) {
            BakedModel model = ClientUtils.getItemRenderer().m_115103_().m_109394_(OreGrowth.ORE_GROWTH_BLOCK.m_5456_());
            if (model instanceof OreGrowthBlockBakedModel) {
                ((OreGrowthBlockBakedModel)model).withContext(this.base, () -> super.render(poseStack, x, y));
            } else {
                super.render(poseStack, x, y);
            }
        }

        public void toBytes(FriendlyByteBuf buf) {
            if (this.wrapped != null) {
                this.wrapped.toBytes(buf);
            } else {
                super.toBytes(buf);
            }
            buf.m_130085_(Registries.BLOCKS.getIdentifier((Object)this.base));
        }
    }
}

