/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaClientRegistration;
import mcp.mobius.waila.api.IWailaCommonRegistration;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.Element;
import mcp.mobius.waila.api.ui.IElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

@WailaPlugin
public class OreGrowthWailaPlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        super.register(registration);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerComponentProvider((tooltip, accessor, config) -> {
            Direction facing = (Direction)accessor.getBlockState().m_61143_(OreGrowthBlock.FACE);
            Block base = accessor.getLevel().m_8055_(accessor.getPosition().m_142300_(facing)).m_60734_();
            tooltip.remove(CorePlugin.TAG_OBJECT_NAME);
            MutableComponent name = TextComponents.translation((String)"oregrowth.ore_growth_block.adjusted_name", (Object[])new Object[]{base.m_49954_()}).get();
            tooltip.add((Component)new TextComponent(String.format(config.getWailaConfig().getFormatting().getBlockName(), name.getString())).m_130948_(config.getWailaConfig().getOverlay().getColor().getTitle()));
        }, TooltipPosition.HEAD, OreGrowthBlock.class);
        registration.registerComponentProvider((tooltip, accessor, config) -> {
            Direction facing = (Direction)accessor.getBlockState().m_61143_(OreGrowthBlock.FACE);
            Block base = accessor.getLevel().m_8055_(accessor.getPosition().m_142300_(facing)).m_60734_();
            OreGrowthRecipe recipe = OreGrowthRecipeManager.get(true).getRecipeFor(base);
            if (recipe != null) {
                float growth = (float)((Integer)accessor.getBlockState().m_61143_((Property)OreGrowthBlock.STAGE)).intValue() / (float)recipe.stages() * 100.0f;
                MutableComponent growthText = TextComponents.string((String)String.format("%.0f%%", Float.valueOf(growth))).color(growth < 100.0f ? ChatFormatting.WHITE : ChatFormatting.GREEN).get();
                tooltip.add((Component)TextComponents.translation((String)"oregrowth.ore_growth_block.growth_hint", (Object[])new Object[]{growthText}).get());
            }
        }, TooltipPosition.BODY, OreGrowthBlock.class);
        registration.registerIconProvider(new IComponentProvider(){

            @Nullable
            public IElement getIcon(BlockAccessor accessor, IPluginConfig config, final IElement currentIcon) {
                BlockState state = accessor.getBlockState();
                Direction facing = (Direction)state.m_61143_(OreGrowthBlock.FACE);
                final Block base = accessor.getLevel().m_8055_(accessor.getPosition().m_142300_(facing)).m_60734_();
                return new Element(){

                    public Vec2 getSize() {
                        return currentIcon.getSize();
                    }

                    public void render(PoseStack poseStack, float x, float y, float maxX, float maxY) {
                        BakedModel model = ClientUtils.getItemRenderer().m_115103_().m_109394_(OreGrowth.ORE_GROWTH_BLOCK.m_5456_());
                        if (model instanceof OreGrowthBlockBakedModel) {
                            ((OreGrowthBlockBakedModel)model).withContext(base, () -> currentIcon.render(poseStack, x, y, maxX, maxY));
                        } else {
                            currentIcon.render(poseStack, x, y, maxX, maxY);
                        }
                    }

                    @Nullable
                    public Component getMessage() {
                        return currentIcon.getMessage();
                    }
                };
            }

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            }
        }, OreGrowthBlock.class);
    }
}

