/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlockBakedModel
implements BakedModel {
    public static final ModelProperty<Block> BASE_BLOCK_PROPERTY = new ModelProperty();
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = OreGrowthBlockBakedModel.findUVOffset(DefaultVertexFormat.f_85811_, VertexFormatElement.Usage.UV);
    private static final int BLOCK_VERTEX_DATA_TINT_OFFSET = OreGrowthBlockBakedModel.findUVOffset(DefaultVertexFormat.f_85811_, VertexFormatElement.Usage.COLOR);
    private static final Direction[] MODEL_DIRECTIONS = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, null};
    private final BakedModel original;
    private final Map<Direction, Map<Block, List<BakedQuad>>> quadCache = new HashMap<Direction, Map<Block, List<BakedQuad>>>();
    private final Map<Block, List<BakedQuad>> directionlessQuadCache = new HashMap<Block, List<BakedQuad>>();
    private final ThreadLocal<Block> baseBlock = new ThreadLocal();

    public OreGrowthBlockBakedModel(BakedModel original) {
        this.original = original;
        for (Direction direction : Direction.values()) {
            this.quadCache.put(direction, new HashMap());
        }
    }

    public void withContext(Block baseBlock, Runnable runnable) {
        this.baseBlock.set(baseBlock);
        runnable.run();
        this.baseBlock.set(null);
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData data) {
        if (data.hasProperty(BASE_BLOCK_PROPERTY)) {
            return data;
        }
        BlockPos basePos = pos.m_142300_((Direction)state.m_61143_(OreGrowthBlock.FACE));
        Block base = level.m_8055_(basePos).m_60734_();
        return new ModelDataMap.Builder().withInitial(BASE_BLOCK_PROPERTY, (Object)base).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random random, @NotNull IModelData data) {
        List<BakedQuad> quads;
        Map<Block, List<BakedQuad>> cache;
        Block base = this.baseBlock.get();
        if (base == null) {
            base = (Block)data.getData(BASE_BLOCK_PROPERTY);
        }
        if (base == null) {
            return this.original.getQuads(state, side, random, data);
        }
        Map<Block, List<BakedQuad>> map = cache = side == null ? this.directionlessQuadCache : this.quadCache.get(side);
        synchronized (map) {
            quads = cache.get(base);
        }
        if (quads == null) {
            quads = this.remapQuads(this.original.m_6840_(state, side, random), base, random);
            map = cache;
            synchronized (map) {
                if (!cache.containsKey(base)) {
                    cache.put(base, quads);
                } else {
                    quads = cache.get(base);
                }
            }
        }
        if (quads == null) {
            throw new IllegalStateException("Tried returning null list from OreGrowthBlockBakedModel#getQuads for side '" + side + "' and base '" + base + "'!");
        }
        return quads;
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random random) {
        return this.getQuads(state, side, random, (IModelData)EmptyModelData.INSTANCE);
    }

    private List<BakedQuad> remapQuads(List<BakedQuad> originalQuads, Block baseBlock, Random random) {
        BlockState baseState = baseBlock.m_49966_();
        BakedModel baseModel = ClientUtils.getBlockRenderer().m_110910_(baseState);
        HashMap spriteCounts = new HashMap();
        for (Direction cullFace : MODEL_DIRECTIONS) {
            baseModel.getQuads(baseState, cullFace, random, (IModelData)EmptyModelData.INSTANCE).forEach(quad -> {
                TextureAtlasSprite sprite = quad.m_173410_();
                Holder count = (Holder)spriteCounts.computeIfAbsent(sprite, s -> Pair.of((Object)new Holder((Object)0), (Object)quad.m_111305_())).left();
                count.set((Object)((Integer)count.get() + 1));
            });
        }
        if (spriteCounts.isEmpty()) {
            return originalQuads;
        }
        TextureAtlasSprite sprite = null;
        int tint = 0;
        int count = 0;
        for (Map.Entry entry : spriteCounts.entrySet()) {
            if ((Integer)((Holder)((Pair)entry.getValue()).left()).get() <= count) continue;
            sprite = (TextureAtlasSprite)entry.getKey();
            tint = (Integer)((Pair)entry.getValue()).right();
        }
        TextureAtlasSprite finalSprite = sprite;
        int n = tint;
        return originalQuads.stream().map(quad -> this.remapQuad((BakedQuad)quad, finalSprite, finalTint)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected BakedQuad remapQuad(BakedQuad quad, TextureAtlasSprite newSprite, int newTint) {
        TextureAtlasSprite sprite = quad.m_173410_();
        int[] vertexData = quad.m_111303_();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        int tintOffset = BLOCK_VERTEX_DATA_TINT_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize;
            float u = Float.intBitsToFloat(vertexData[offset + uvOffset]);
            float newU = newSprite.m_118409_() + (u - sprite.m_118409_()) / (sprite.m_118410_() - sprite.m_118409_()) * (newSprite.m_118410_() - newSprite.m_118409_());
            vertexData[offset + uvOffset] = Float.floatToRawIntBits(newU);
            float v = Float.intBitsToFloat(vertexData[offset + uvOffset + 1]);
            float newV = newSprite.m_118411_() + (v - sprite.m_118411_()) / (sprite.m_118412_() - sprite.m_118411_()) * (newSprite.m_118412_() - newSprite.m_118411_());
            vertexData[offset + uvOffset + 1] = Float.floatToRawIntBits(newV);
            vertexData[offset + tintOffset] = newTint;
        }
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, TextureAtlasSprite sprite) {
        int vertexSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.m_118410_() - sprite.m_118409_();
            float u = Float.intBitsToFloat(vertexData[offset]) + width * (float)newU;
            vertexData[offset] = Float.floatToRawIntBits(u);
            float height = sprite.m_118412_() - sprite.m_118411_();
            float v = Float.intBitsToFloat(vertexData[offset + 1]) + height * (float)newV;
            vertexData[offset + 1] = Float.floatToRawIntBits(v);
        }
        return vertexData;
    }

    private static int findUVOffset(VertexFormat vertexFormat, VertexFormatElement.Usage vertexFormatElement) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < vertexFormat.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(index);
            if (el.m_86048_() != vertexFormatElement) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a '" + vertexFormat + "' attribute");
        }
        return vertexFormat.f_86013_.getInt(index);
    }

    public boolean m_7521_() {
        return this.original.m_7521_();
    }

    public ItemTransforms m_7442_() {
        return this.original.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7541_() {
        return this.original.m_7541_();
    }

    public boolean m_7539_() {
        return this.original.m_7539_();
    }

    public boolean m_7547_() {
        return this.original.m_7547_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.original.m_6160_();
    }
}

