/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.mixin;

import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin {
    @Unique
    private boolean isRandomlyTicking;

    @Inject(method={"initCache"}, at={@At(value="TAIL")})
    private void initCache(CallbackInfo ci) {
        BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
        this.isRandomlyTicking = OreGrowthRecipeManager.get(false).getRecipeFor(state.m_60734_()) != null;
    }

    @Inject(method={"isRandomlyTicking"}, at={@At(value="HEAD")}, cancellable=true)
    private void isRandomlyTicking(CallbackInfoReturnable<Boolean> ci) {
        if (this.isRandomlyTicking) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")})
    private void randomTick(ServerLevel level, BlockPos pos, Random random, CallbackInfo ci) {
        if (!this.isRandomlyTicking) {
            return;
        }
        BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.f_46443_).getRecipeFor(state.m_60734_());
        if (recipe != null) {
            OreGrowthBlock.trySpawnOreGrowth(state, recipe, level, pos, random);
        }
    }

    @Inject(method={"is(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void is(TagKey<Block> tag, CallbackInfoReturnable<Boolean> ci) {
        BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
        Block block = state.m_60734_();
        if ((block == OreGrowth.ORE_GROWTH_BLOCK || block == OreGrowth.COMPLETE_ORE_GROWTH_BLOCK) && ((OreGrowthBlock)block).is(state, tag)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"is(Lnet/minecraft/core/HolderSet;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void is(HolderSet<Block> tag, CallbackInfoReturnable<Boolean> ci) {
        BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
        Block block = state.m_60734_();
        if ((block == OreGrowth.ORE_GROWTH_BLOCK || block == OreGrowth.COMPLETE_ORE_GROWTH_BLOCK) && tag instanceof HolderSet.Named && ((OreGrowthBlock)block).is(state, (TagKey<Block>)((HolderSet.Named)tag).m_205839_())) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"requiresCorrectToolForDrops()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void requiresCorrectToolForDrops(CallbackInfoReturnable<Boolean> ci) {
        BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
        Block block = state.m_60734_();
        if (block == OreGrowth.ORE_GROWTH_BLOCK || block == OreGrowth.COMPLETE_ORE_GROWTH_BLOCK) {
            ci.setReturnValue((Object)((OreGrowthBlock)block).requiresCorrectToolForDrops(state));
        }
    }
}

