/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.util.Triple;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableHelper {
    public static List<LootEntry> entriesInTable(ResourceLocation tableIdentifier, Function<ResourceLocation, LootTable> lookup) {
        return LootTableHelper.entriesInTable(lookup.apply(tableIdentifier), lookup);
    }

    private static List<LootEntry> entriesInTable(LootTable table, Function<ResourceLocation, LootTable> lookup) {
        ArrayList<LootEntry> items = new ArrayList();
        for (LootPool pool : table.pools) {
            float rolls = LootTableHelper.averageValue(pool.rolls);
            int totalWeight = pool.entries.stream().mapToInt(LootTableHelper::containerWeight).sum();
            pool.entries.stream().flatMap(container -> LootTableHelper.itemsFromContainer(container, totalWeight, lookup)).map(entry -> entry.withChance(1.0 - Math.pow(1.0 - entry.chance, rolls))).forEach(items::add);
        }
        items = new ArrayList(items.stream().collect(Collectors.toMap(entry -> Triple.of((Object)entry.stack.getItem(), (Object)entry.stack.getComponentsPatch(), (Object)Pair.of((Object)entry.stack.getCount(), entry.conditions)), Function.identity(), (first, second) -> first.withChance(1.0 - (1.0 - first.chance) * (1.0 - second.chance)))).values());
        return items;
    }

    private static int containerWeight(LootPoolEntryContainer container) {
        if (container instanceof LootPoolSingletonContainer) {
            return ((LootPoolSingletonContainer)container).weight;
        }
        if (container instanceof AlternativesEntry) {
            return ((AlternativesEntry)container).children.stream().mapToInt(LootTableHelper::containerWeight).max().orElse(0);
        }
        if (container instanceof EntryGroup) {
            return ((EntryGroup)container).children.stream().mapToInt(LootTableHelper::containerWeight).sum();
        }
        if (container instanceof SequentialEntry) {
            return ((SequentialEntry)container).children.stream().mapToInt(LootTableHelper::containerWeight).sum();
        }
        return 1;
    }

    private static Stream<LootEntry> itemsFromContainer(LootPoolEntryContainer container, int totalWeight, Function<ResourceLocation, LootTable> lookup) {
        List<LootEntryConditions> conditions = container.conditions.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
        if (container instanceof AlternativesEntry) {
            MutableComponent not = TextComponents.translation((String)"oregrowth.jei_category.conditions.none_of").get();
            LinkedHashSet previousConditions = new LinkedHashSet();
            ArrayList entries = new ArrayList();
            for (LootPoolEntryContainer child : ((AlternativesEntry)container).children) {
                Stream<LootEntry> stream = LootTableHelper.itemsFromContainer(child, totalWeight, lookup);
                if (!previousConditions.isEmpty()) {
                    stream = stream.map(entry -> entry.prependConditions(Stream.concat(conditions.stream(), Stream.of(new LootEntryConditions(not, new ArrayList<LootEntryConditions>(previousConditions)))), conditions.size() + 1));
                }
                stream.forEach(entries::add);
                child.conditions.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).forEach(previousConditions::add);
            }
            return entries.stream();
        }
        if (container instanceof EntryGroup) {
            return ((EntryGroup)container).children.stream().flatMap(c -> LootTableHelper.itemsFromContainer(c, totalWeight, lookup)).map(entry -> entry.prependConditions(conditions.stream(), conditions.size()));
        }
        if (container instanceof SequentialEntry) {
            LinkedHashSet previousConditions = new LinkedHashSet();
            return ((SequentialEntry)container).children.stream().flatMap(c -> LootTableHelper.itemsFromContainer(c, totalWeight, lookup)).map(entry -> {
                LootEntry newEntry = entry.prependConditions(Stream.concat(conditions.stream(), previousConditions.stream()), conditions.size() + previousConditions.size());
                previousConditions.addAll(entry.conditions);
                return newEntry;
            });
        }
        if (container instanceof LootItem) {
            return Stream.of(new LootEntry(new ItemStack(((LootItem)container).item), (double)((LootItem)container).weight / (double)totalWeight, conditions));
        }
        if (container instanceof NestedLootTable) {
            return LootTableHelper.entriesInTable((LootTable)((NestedLootTable)container).contents.map(key -> (LootTable)lookup.apply(key.location()), Function.identity()), lookup).stream().map(entry -> entry.withChance(entry.chance * (double)((NestedLootTable)container).weight / (double)totalWeight).prependConditions(conditions.stream(), conditions.size()));
        }
        return Stream.empty();
    }

    private static LootEntryConditions formatCondition(LootItemCondition condition) {
        if (condition instanceof AllOfCondition) {
            List<LootEntryConditions> subs = ((AllOfCondition)condition).terms.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
            if (subs.isEmpty()) {
                return null;
            }
            if (subs.size() == 1) {
                return subs.get(0);
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.all_of").get(), subs);
        }
        if (condition instanceof AnyOfCondition) {
            List<LootEntryConditions> subs = ((AnyOfCondition)condition).terms.stream().map(LootTableHelper::formatCondition).filter(Objects::nonNull).toList();
            if (subs.isEmpty()) {
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.never").get(), List.of());
            }
            if (subs.size() == 1) {
                return subs.get(0);
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.any_of").get(), subs);
        }
        if (condition instanceof InvertedLootItemCondition) {
            LootEntryConditions sub = LootTableHelper.formatCondition(((InvertedLootItemCondition)condition).term());
            if (sub == null) {
                return null;
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.not").get(), List.of(sub));
        }
        if (condition instanceof WeatherCheck) {
            if (((WeatherCheck)condition).isRaining().isPresent()) {
                if (((Boolean)((WeatherCheck)condition).isRaining().get()).booleanValue()) {
                    return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.raining").get(), List.of());
                }
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.raining.not").get(), List.of());
            }
            if (((WeatherCheck)condition).isThundering().isPresent()) {
                if (((Boolean)((WeatherCheck)condition).isThundering().get()).booleanValue()) {
                    return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.thundering").get(), List.of());
                }
                return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.thundering.not").get(), List.of());
            }
            return null;
        }
        if (condition instanceof MatchTool) {
            if (((MatchTool)condition).predicate().isEmpty()) {
                return null;
            }
            MutableComponent predicate = LootTableHelper.formatItemPredicate((ItemPredicate)((MatchTool)condition).predicate().get());
            if (predicate == null) {
                return null;
            }
            return new LootEntryConditions(TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool").append(predicate).get(), List.of());
        }
        return null;
    }

    private static MutableComponent formatItemPredicate(ItemPredicate predicate) {
        MutableComponent enchantments = null;
        List<Enchantment> actualEnchants = Stream.concat(predicate.components().exact().asPatch().get(DataComponents.ENCHANTMENTS).map(c -> c.keySet().stream()).orElseGet(() -> Stream.of(new Holder[0])).filter(Holder::isBound).map(Holder::value), predicate.components().partial().values().stream().filter(EnchantmentsPredicate.Enchantments.class::isInstance).map(EnchantmentsPredicate.Enchantments.class::cast).flatMap(p -> p.enchantments.stream()).map(EnchantmentPredicate::enchantments).filter(Optional::isPresent).map(Optional::get).flatMap(HolderSet::stream).filter(Holder::isBound).map(Holder::value)).distinct().toList();
        if (actualEnchants.size() == 1) {
            enchantments = TextComponents.fromTextComponent((Component)actualEnchants.get(0).description()).color(ChatFormatting.GOLD).get();
        } else if (actualEnchants.size() == 2) {
            MutableComponent enchant1 = TextComponents.fromTextComponent((Component)actualEnchants.get(0).description()).color(ChatFormatting.GOLD).get();
            MutableComponent enchant2 = TextComponents.fromTextComponent((Component)actualEnchants.get(1).description()).color(ChatFormatting.GOLD).get();
            enchantments = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.two_items", (Object[])new Object[]{enchant1, enchant2}).get();
        } else if (actualEnchants.size() > 2) {
            TextComponents.TextComponentBuilder builder = TextComponents.fromTextComponent((Component)actualEnchants.get(0).description()).color(ChatFormatting.GOLD);
            for (int i = 1; i < actualEnchants.size() - 1; ++i) {
                builder = builder.string(", ").append(TextComponents.fromTextComponent((Component)actualEnchants.get(i).description()).color(ChatFormatting.GOLD).get());
            }
            MutableComponent lastEnchant = TextComponents.fromTextComponent((Component)actualEnchants.get(actualEnchants.size() - 1).description()).color(ChatFormatting.GOLD).get();
            enchantments = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.more_items", (Object[])new Object[]{builder.get(), lastEnchant}).get();
        }
        if (predicate.items().isPresent() && predicate.items().get() instanceof HolderSet.Named) {
            ResourceLocation tag = ((HolderSet.Named)predicate.items().get()).key().location();
            if (enchantments == null) {
                return TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.tag", (Object[])new Object[]{tag}).get();
            }
            return TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.tag", (Object[])new Object[]{tag}).translation("oregrowth.jei_category.conditions.match_tool.enchanted", new Object[]{enchantments}).get();
        }
        if (predicate.items().isPresent()) {
            TextComponents.TextComponentBuilder itemsFormatted;
            if (((HolderSet)predicate.items().get()).size() == 0) {
                return null;
            }
            List<TextComponents.TextComponentBuilder> items = ((HolderSet)predicate.items().get()).stream().map(Holder::value).map(TextComponents::item).map(b -> b.color(ChatFormatting.GOLD)).sorted(Comparator.comparing(TextComponents.TextComponentBuilder::format)).toList();
            if (((HolderSet)predicate.items().get()).size() == 1) {
                itemsFormatted = items.get(0);
            } else if (((HolderSet)predicate.items().get()).size() == 2) {
                itemsFormatted = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.two_items", (Object[])new Object[]{items.get(0), items.get(1)});
            } else if (((HolderSet)predicate.items().get()).size() > 2) {
                TextComponents.TextComponentBuilder builder = items.get(0);
                for (int i = 1; i < ((HolderSet)predicate.items().get()).size() - 1; ++i) {
                    builder = builder.string(", ").append(items.get(i).get());
                }
                itemsFormatted = TextComponents.translation((String)"oregrowth.jei_category.conditions.match_tool.more_items", (Object[])new Object[]{builder.get(), items.get(items.size() - 1)});
            } else {
                throw new AssertionError();
            }
            if (enchantments != null) {
                itemsFormatted = itemsFormatted.translation("oregrowth.jei_category.conditions.match_tool.enchanted", new Object[]{enchantments});
            }
            return itemsFormatted.get();
        }
        return enchantments;
    }

    private static float averageValue(NumberProvider provider) {
        if (provider instanceof BinomialDistributionGenerator) {
            return LootTableHelper.averageValue(((BinomialDistributionGenerator)provider).n()) * LootTableHelper.averageValue(((BinomialDistributionGenerator)provider).p());
        }
        if (provider instanceof ConstantValue) {
            return ((ConstantValue)provider).value();
        }
        if (provider instanceof UniformGenerator) {
            return (LootTableHelper.averageValue(((UniformGenerator)provider).min()) + LootTableHelper.averageValue(((UniformGenerator)provider).max())) / 2.0f;
        }
        return -1.0f;
    }

    public record LootEntry(ItemStack stack, double chance, Collection<LootEntryConditions> conditions) {
        LootEntry withChance(double chance) {
            return new LootEntry(this.stack, chance, this.conditions);
        }

        LootEntry prependConditions(Stream<LootEntryConditions> conditions, int count) {
            LinkedHashSet<LootEntryConditions> merged = new LinkedHashSet<LootEntryConditions>(this.conditions.size() + count);
            conditions.forEach(merged::add);
            merged.addAll(this.conditions);
            return new LootEntry(this.stack, this.chance, merged);
        }
    }

    public record LootEntryConditions(MutableComponent component, List<LootEntryConditions> subConditions) {
        public List<MutableComponent> toComponents() {
            if (this.subConditions.isEmpty()) {
                return List.of(TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet").append(this.component).get());
            }
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            components.add(TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet").append(this.component).get());
            this.subConditions.stream().map(LootEntryConditions::toComponents).flatMap(Collection::stream).map(component -> TextComponents.translation((String)"oregrowth.jei_category.conditions.bullet.spacing").append(component).get()).forEach(components::add);
            return components;
        }
    }
}

