/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.compat.jei.OreGrowthJEIPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class OreGrowthJEIRecipeCategory
implements IRecipeCategory<OreGrowthRecipe> {
    private static final RandomSource RANDOM = RandomSource.create();
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable slotBackground;
    private final IDrawable icon;
    private final IIngredientManager ingredientManager;

    public OreGrowthJEIRecipeCategory(IGuiHelper guiHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"oregrowth", (String)"textures/screen/jei_category_background.png"), 0, 8, 111, 56);
        this.arrow = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"oregrowth", (String)"textures/screen/jei_category_background.png"), 111, 0, 32, 15);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)OreGrowth.ORE_GROWTH_BLOCK));
        this.ingredientManager = ingredientManager;
    }

    public RecipeType<OreGrowthRecipe> getRecipeType() {
        return OreGrowthJEIPlugin.ORE_GROWTH_RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"oregrowth.jei_category.title").get();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, OreGrowthRecipe recipe, IFocusGroup focusGroup) {
        layoutBuilder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(OreGrowth.ORE_GROWTH_ITEM.getDefaultInstance());
        int outputs = Math.min(recipe.getRecipeViewerDrops().size(), 6);
        int columns = outputs > 1 ? 2 : 1;
        int rows = (outputs + 1) / 2;
        for (int i = 0; i < outputs; ++i) {
            OreGrowthRecipe.RecipeViewerDrop drop = recipe.getRecipeViewerDrops().get(i);
            int x = 93 - columns * 9 + i % columns * 18;
            int y = 29 - rows * 9 + i / columns * 18;
            ArrayList<Object> tooltips = new ArrayList<Object>(3);
            tooltips.add(TextComponents.empty().get());
            MutableComponent minGrowth = TextComponents.number((int)((int)Math.round((double)drop.minStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            MutableComponent maxGrowth = TextComponents.number((int)((int)Math.round((double)drop.maxStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            if (drop.maxStage() > 1 || drop.maxStage() < recipe.stages()) {
                if (drop.minStage() == drop.maxStage()) {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth", (Object[])new Object[]{minGrowth}).get());
                } else {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth.range", (Object[])new Object[]{minGrowth, maxGrowth}).get());
                }
            }
            if (drop.chance() < 1.0) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.chance", (Object[])new Object[]{TextComponents.number((double)(drop.chance() * 100.0)).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get()}).get());
            }
            if (!drop.tooltip().isEmpty()) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.conditions").get());
                tooltips.addAll(drop.tooltip());
            }
            layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground(this.slotBackground, -1, -1).addRichTooltipCallback((slotView, list) -> list.addAll((Collection)tooltips)).addItemStack(drop.result());
        }
        final IIngredientRenderer originalRenderer = this.ingredientManager.getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK);
        ((IRecipeSlotBuilder)layoutBuilder.addSlot(RecipeIngredientRole.CATALYST, columns == 1 ? 11 : 2, 24).setSlotName("base").addItemStacks(recipe.bases((HolderLookup.RegistryLookup<Block>)BuiltInRegistries.BLOCK).stream().map(Block::asItem).map(Item::getDefaultInstance).toList())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(this){

            public void render(GuiGraphics guiGraphics, ItemStack stack) {
            }

            public void getTooltip(ITooltipBuilder tooltip, ItemStack ingredient, TooltipFlag tooltipFlag) {
                originalRenderer.getTooltip(tooltip, (Object)ingredient, tooltipFlag);
            }

            public List<Component> getTooltip(ItemStack stack, TooltipFlag flag) {
                return List.of();
            }

            public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
                return originalRenderer.getFontRenderer(minecraft, (Object)ingredient);
            }

            public int getWidth() {
                return 30;
            }

            public int getHeight() {
                return 30;
            }
        });
    }

    public void draw(OreGrowthRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.pose().popMatrix();
        if (slotsView.getSlotViews(RecipeIngredientRole.OUTPUT).size() <= 1) {
            guiGraphics.pose().translate(9.0f, 0.0f);
        }
        this.arrow.draw(guiGraphics, 37, 20);
        guiGraphics.renderFakeItem(Items.DIAMOND_PICKAXE.getDefaultInstance(), 43, 18);
        Block base = slotsView.findSlotByName("base").flatMap(IRecipeSlotView::getDisplayedItemStack).map(ItemStack::getItem).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).getBlock()).orElse(null);
        if (base != null) {
            GuiGraphicsHelper.of((GuiGraphics)guiGraphics).submitCustomRendering(22, 39, 40, 40, poseStack -> OreGrowthJEIRecipeCategory.renderModel(poseStack, base.defaultBlockState(), 22, 39, 0, ModelData.EMPTY));
        }
        if (base != null) {
            int stage = (int)(System.currentTimeMillis() / 1200L % (long)recipe.stages() + 1L);
            BlockState state = (BlockState)OreGrowth.ORE_GROWTH_BLOCK.defaultBlockState().setValue((Property)OreGrowthBlock.STAGE, (Comparable)Integer.valueOf(stage));
            ModelData modelData = ModelData.builder().with(OreGrowthBlockBakedModel.BASE_BLOCK_PROPERTY, (Object)base).build();
            GuiGraphicsHelper.of((GuiGraphics)guiGraphics).submitCustomRendering(22, 39, 40, 40, poseStack -> OreGrowthJEIRecipeCategory.renderModel(poseStack, state, 22, 23, 10, modelData));
        }
        guiGraphics.pose().popMatrix();
    }

    private static void renderModel(PoseStack poseStack, BlockState state, int x, int y, int offset, ModelData modelData) {
        poseStack.translate((float)(x + 21), (float)(y + 16), (float)(150 + offset));
        poseStack.scale(1.85f, 1.85f, 1.85f);
        poseStack.scale(16.0f, -16.0f, 16.0f);
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationXYZ(0.5235988f, 3.9269907f, 0.0f));
        poseStack.scale(0.625f, 0.625f, 0.625f);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        RANDOM.setSeed(42L);
        for (ChunkSectionLayer layer : model.getRenderTypes(state, RANDOM, modelData)) {
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)layer)), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelData)modelData, (ChunkSectionLayer)layer);
        }
    }
}

