/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlockBakedModel
implements BlockStateModel {
    public static final ModelProperty<Block> BASE_BLOCK_PROPERTY = new ModelProperty();
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = OreGrowthBlockBakedModel.findUVOffset(DefaultVertexFormat.BLOCK, VertexFormatElement.Usage.UV);
    private static final Direction[] MODEL_DIRECTIONS = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, null};
    private final BlockStateModel original;
    private final Map<Block, List<BlockModelPart>> meshCache = new HashMap<Block, List<BlockModelPart>>();

    public OreGrowthBlockBakedModel(BlockStateModel original) {
        this.original = original;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData data) {
        if (data.has(BASE_BLOCK_PROPERTY)) {
            return data;
        }
        BlockPos basePos = pos.relative((Direction)state.getValue(OreGrowthBlock.FACE));
        Block base = level.getBlockState(basePos).getBlock();
        return ModelData.builder().with(BASE_BLOCK_PROPERTY, (Object)base).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectParts(RandomSource random, List<BlockModelPart> parts, ModelData modelData, @Nullable ChunkSectionLayer layer) {
        List<BlockModelPart> mesh;
        Block base = (Block)modelData.get(BASE_BLOCK_PROPERTY);
        if (base == null) {
            this.original.collectParts(random, parts, modelData, layer);
            return;
        }
        Map<Block, List<BlockModelPart>> map = this.meshCache;
        synchronized (map) {
            mesh = this.meshCache.get(base);
        }
        if (mesh == null) {
            mesh = this.computeMesh(model -> model.collectParts(random, ModelData.EMPTY, null), base);
            map = this.meshCache;
            synchronized (map) {
                if (!this.meshCache.containsKey(base)) {
                    this.meshCache.put(base, mesh);
                } else {
                    mesh = this.meshCache.get(base);
                }
            }
        }
        parts.addAll(mesh);
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        this.original.collectParts(random, parts);
    }

    private List<BlockModelPart> computeMesh(Function<BlockStateModel, List<BlockModelPart>> modelEmitter, Block baseBlock) {
        BlockState baseState = baseBlock.defaultBlockState();
        BlockStateModel baseModel = ClientUtils.getBlockRenderer().getBlockModel(baseState);
        HashMap spriteCounts = new HashMap();
        for (BlockModelPart part : modelEmitter.apply(baseModel)) {
            for (Direction cullFace : MODEL_DIRECTIONS) {
                part.getQuads(cullFace).forEach(quad -> {
                    TextureAtlasSprite sprite = quad.sprite();
                    Holder count = (Holder)spriteCounts.computeIfAbsent(sprite, s -> Pair.of((Object)new Holder((Object)0), (Object)new MaterialEntry(sprite, quad.shade(), quad.lightEmission(), quad.ambientOcclusion()))).left();
                    count.set((Object)((Integer)count.get() + 1));
                });
            }
        }
        if (spriteCounts.isEmpty()) {
            return modelEmitter.apply(this.original);
        }
        MaterialEntry material = null;
        int count = 0;
        for (Pair entry : spriteCounts.values()) {
            if ((Integer)((Holder)entry.left()).get() <= count) continue;
            material = (MaterialEntry)entry.right();
        }
        final EnumMap quads = new EnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            quads.put(direction, new ArrayList());
        }
        final ArrayList<BakedQuad> directionLessQuads = new ArrayList<BakedQuad>();
        for (BlockModelPart part : modelEmitter.apply(this.original)) {
            for (Direction cullDirection : MODEL_DIRECTIONS) {
                for (BakedQuad quad2 : part.getQuads(cullDirection)) {
                    if (cullDirection == null) {
                        directionLessQuads.add(OreGrowthBlockBakedModel.remapQuad(quad2, material));
                        continue;
                    }
                    ((List)quads.get(cullDirection)).add(OreGrowthBlockBakedModel.remapQuad(quad2, material));
                }
            }
        }
        final TextureAtlasSprite sprite = material.sprite;
        final boolean ambientOcclusion = material.ambientOcclusion;
        return List.of(new BlockModelPart(){

            public List<BakedQuad> getQuads(@Nullable Direction cullDirection) {
                return cullDirection == null ? directionLessQuads : (List)quads.get(cullDirection);
            }

            public TextureAtlasSprite particleIcon() {
                return sprite;
            }

            public boolean useAmbientOcclusion() {
                return ambientOcclusion;
            }
        });
    }

    private static BakedQuad remapQuad(BakedQuad quad, MaterialEntry material) {
        TextureAtlasSprite sprite = quad.sprite();
        int[] vertexData = quad.vertices();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        int vertexSize = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        TextureAtlasSprite newSprite = material.sprite;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize;
            float u = Float.intBitsToFloat(vertexData[offset + uvOffset]);
            float newU = newSprite.getU0() + (u - sprite.getU0()) / (sprite.getU1() - sprite.getU0()) * (newSprite.getU1() - newSprite.getU0());
            vertexData[offset + uvOffset] = Float.floatToRawIntBits(newU);
            float v = Float.intBitsToFloat(vertexData[offset + uvOffset + 1]);
            float newV = newSprite.getV0() + (v - sprite.getV0()) / (sprite.getV1() - sprite.getV0()) * (newSprite.getV1() - newSprite.getV0());
            vertexData[offset + uvOffset + 1] = Float.floatToRawIntBits(newV);
        }
        return new BakedQuad(vertexData, quad.tintIndex(), quad.direction(), newSprite, material.shading, material.lightEmission, material.ambientOcclusion);
    }

    private static int findUVOffset(VertexFormat vertexFormat, VertexFormatElement.Usage usage) {
        VertexFormatElement element = null;
        for (int index = 0; index < vertexFormat.getElements().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.getElements().get(index);
            if (el.usage() != usage) continue;
            element = el;
            break;
        }
        if (element == null) {
            throw new RuntimeException("Expected vertex format to have a '" + String.valueOf(vertexFormat) + "' attribute");
        }
        return vertexFormat.getOffset(element);
    }

    public TextureAtlasSprite particleIcon(ModelData modelData) {
        BlockState baseState;
        Block base = (Block)modelData.get(BASE_BLOCK_PROPERTY);
        if (base == null || (baseState = base.defaultBlockState()).isAir()) {
            return this.original.particleIcon(modelData);
        }
        BlockStateModel baseModel = ClientUtils.getBlockRenderer().getBlockModel(baseState);
        return baseModel.particleIcon(ModelData.EMPTY);
    }

    public TextureAtlasSprite particleIcon() {
        return this.original.particleIcon();
    }

    private record MaterialEntry(TextureAtlasSprite sprite, boolean shading, int lightEmission, boolean ambientOcclusion) {
    }
}

