/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.mixin;

import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import com.supermartijn642.oregrowth.extensions.OreGrowthBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public class BlockStateBaseMixin
implements OreGrowthBlockState {
    @Unique
    private boolean hasOreGrowthRecipe;
    @Unique
    private boolean recipeCached;

    @Override
    public void oreGrowthInvalidate() {
        this.recipeCached = false;
    }

    @Inject(method={"isRandomlyTicking"}, at={@At(value="HEAD")}, cancellable=true)
    private void isRandomlyTicking(CallbackInfoReturnable<Boolean> ci) {
        if (!this.recipeCached) {
            BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
            this.hasOreGrowthRecipe = OreGrowthRecipeManager.get(false).getRecipeFor(state.getBlock()) != null;
            this.recipeCached = true;
        }
        if (this.hasOreGrowthRecipe) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")})
    private void randomTick(ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (!this.recipeCached || !this.hasOreGrowthRecipe) {
            return;
        }
        BlockBehaviour.BlockStateBase state = (BlockBehaviour.BlockStateBase)this;
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.isClientSide).getRecipeFor(state.getBlock());
        if (recipe != null) {
            OreGrowthBlock.trySpawnOreGrowth(recipe, level, pos, random);
        }
    }
}

