/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.compat.jei.OreGrowthJEIPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;

public class OreGrowthJEIRecipeCategory
implements IRecipeCategory<OreGrowthRecipe> {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable slotBackground;
    private final IDrawable icon;
    private final IIngredientManager ingredientManager;

    public OreGrowthJEIRecipeCategory(IGuiHelper guiHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createDrawable(new ResourceLocation("oregrowth", "textures/screen/jei_category_background.png"), 0, 8, 111, 56);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("oregrowth", "textures/screen/jei_category_background.png"), 111, 0, 32, 15);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)OreGrowth.COMPLETE_ORE_GROWTH_BLOCK));
        this.ingredientManager = ingredientManager;
    }

    public RecipeType<OreGrowthRecipe> getRecipeType() {
        return OreGrowthJEIPlugin.ORE_GROWTH_RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"oregrowth.jei_category.title").get();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, OreGrowthRecipe recipe, IFocusGroup focusGroup) {
        layoutBuilder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(OreGrowth.ORE_GROWTH_ITEM.m_7968_()).addItemStack(OreGrowth.COMPLETE_ORE_GROWTH_ITEM.m_7968_());
        int outputs = Math.min(recipe.getRecipeViewerDrops().size(), 6);
        int columns = outputs > 1 ? 2 : 1;
        int rows = (outputs + 1) / 2;
        for (int i = 0; i < outputs; ++i) {
            OreGrowthRecipe.RecipeViewerDrop drop = recipe.getRecipeViewerDrops().get(i);
            int x = 93 - columns * 9 + i % columns * 18;
            int y = 29 - rows * 9 + i / columns * 18;
            ArrayList<Object> tooltips = new ArrayList<Object>(3);
            tooltips.add(TextComponents.empty().get());
            MutableComponent minGrowth = TextComponents.number((int)((int)Math.round((double)drop.minStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            MutableComponent maxGrowth = TextComponents.number((int)((int)Math.round((double)drop.maxStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            if (drop.maxStage() > 1 || drop.maxStage() < recipe.stages()) {
                if (drop.minStage() == drop.maxStage()) {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth", (Object[])new Object[]{minGrowth}).get());
                } else {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth.range", (Object[])new Object[]{minGrowth, maxGrowth}).get());
                }
            }
            if (drop.chance() < 1.0) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.chance", (Object[])new Object[]{TextComponents.number((double)(drop.chance() * 100.0)).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get()}).get());
            }
            if (!drop.tooltip().isEmpty()) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.conditions").get());
                tooltips.addAll(drop.tooltip());
            }
            layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground(this.slotBackground, -1, -1).addTooltipCallback((slotView, list) -> list.addAll(tooltips)).addItemStack(drop.result());
        }
        final IIngredientRenderer originalRenderer = this.ingredientManager.getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK);
        ((IRecipeSlotBuilder)layoutBuilder.addSlot(RecipeIngredientRole.CATALYST, columns == 1 ? 11 : 2, 24).setSlotName("base").addItemStacks(recipe.bases((HolderLookup<Block>)HolderLookup.m_235701_((Registry)Registry.f_122824_)).stream().map(Block::m_5456_).map(Item::m_7968_).toList())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(){

            public void render(PoseStack poseStack, ItemStack stack) {
            }

            public List<Component> getTooltip(ItemStack stack, TooltipFlag flag) {
                return originalRenderer.getTooltip((Object)stack, flag);
            }

            public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
                return originalRenderer.getFontRenderer(minecraft, (Object)ingredient);
            }

            public int getWidth() {
                return 30;
            }

            public int getHeight() {
                return 30;
            }
        });
    }

    public void draw(OreGrowthRecipe recipe, IRecipeSlotsView slotsView, PoseStack poseStack, double mouseX, double mouseY) {
        poseStack.m_85836_();
        if (slotsView.getSlotViews(RecipeIngredientRole.OUTPUT).size() <= 1) {
            poseStack.m_85837_(9.0, 0.0, 0.0);
        }
        this.arrow.draw(poseStack, 37, 20);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        RenderSystem.m_69482_();
        ClientUtils.getItemRenderer().m_115218_(Items.f_42390_.m_7968_(), 43, 16);
        RenderSystem.m_69465_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        Block base = slotsView.findSlotByName("base").flatMap(IRecipeSlotView::getDisplayedItemStack).map(ItemStack::m_41720_).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).m_40614_()).orElse(null);
        if (base != null) {
            OreGrowthJEIRecipeCategory.renderModel(poseStack, base.m_49966_(), 9, 31, 0, ModelData.EMPTY);
        }
        if (base != null) {
            int stage = (int)(System.currentTimeMillis() / 1200L % (long)recipe.stages() + 1L);
            BlockState state = (BlockState)OreGrowth.ORE_GROWTH_BLOCK.m_49966_().m_61124_((Property)OreGrowthBlock.STAGE, (Comparable)Integer.valueOf(stage));
            ModelData modelData = ModelData.builder().with(OreGrowthBlockBakedModel.BASE_BLOCK_PROPERTY, (Object)base).build();
            OreGrowthJEIRecipeCategory.renderModel(poseStack, state, 9, 15, 10, modelData);
        }
        poseStack.m_85849_();
    }

    private static void renderModel(PoseStack poseStack, BlockState state, int x, int y, int offset, ModelData modelData) {
        boolean blockLight;
        ClientUtils.getTextureManager().m_118506_(TextureAtlases.getBlocks()).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlases.getBlocks());
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        modelViewStack.m_85837_((double)(x + 8), (double)(y + 8), (double)(150 + offset));
        modelViewStack.m_85841_(1.85f, 1.85f, 1.85f);
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        boolean bl = blockLight = !model.m_7547_();
        if (blockLight) {
            Lighting.m_84930_();
        }
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_85845_(new Quaternion(30.0f, 225.0f, 0.0f, true));
        poseStack2.m_85841_(0.625f, 0.625f, 0.625f);
        poseStack2.m_85837_(-0.5, -0.5, -0.5);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        RANDOM.m_188584_(42L);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, RANDOM, modelData);
        RenderType renderType = renderTypes.contains(RenderType.m_110466_()) ? Sheets.m_110792_() : Sheets.m_110790_();
        ClientUtils.getBlockRenderer().renderSingleBlock(state, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
        bufferSource.m_109911_();
        if (blockLight) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

