/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat.rei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.compat.rei.OreGrowthREIDisplay;
import com.supermartijn642.oregrowth.compat.rei.OreGrowthREIPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class OreGrowthREIRecipeCategory
implements DisplayCategory<OreGrowthREIDisplay> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("oregrowth", "textures/screen/jei_category_background.png");
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    public CategoryIdentifier<? extends OreGrowthREIDisplay> getCategoryIdentifier() {
        return OreGrowthREIPlugin.ORE_GROWTH_CATEGORY;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"oregrowth.jei_category.title").get();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)OreGrowth.COMPLETE_ORE_GROWTH_ITEM);
    }

    public int getDisplayWidth(OreGrowthREIDisplay display) {
        return 121;
    }

    public int getDisplayHeight() {
        return 66;
    }

    public List<Widget> setupDisplay(OreGrowthREIDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int startX = bounds.x + 5;
        int startY = bounds.y + 5;
        final OreGrowthRecipe recipe = display.getRecipe();
        int outputs = Math.min(recipe.getRecipeViewerDrops().size(), 6);
        int columns = outputs > 1 ? 2 : 1;
        int rows = (outputs + 1) / 2;
        for (int i = 0; i < outputs; ++i) {
            OreGrowthRecipe.RecipeViewerDrop drop = recipe.getRecipeViewerDrops().get(i);
            int x = 93 - columns * 9 + i % columns * 18;
            int y = 29 - rows * 9 + i / columns * 18;
            ArrayList<Object> tooltips = new ArrayList<Object>(3);
            tooltips.add(TextComponents.empty().get());
            MutableComponent minGrowth = TextComponents.number((int)((int)Math.round((double)drop.minStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            MutableComponent maxGrowth = TextComponents.number((int)((int)Math.round((double)drop.maxStage() / (double)recipe.stages() * 100.0))).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get();
            if (drop.maxStage() > 1 || drop.maxStage() < recipe.stages()) {
                if (drop.minStage() == drop.maxStage()) {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth", (Object[])new Object[]{minGrowth}).get());
                } else {
                    tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.growth.range", (Object[])new Object[]{minGrowth, maxGrowth}).get());
                }
            }
            if (drop.chance() < 1.0) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.chance", (Object[])new Object[]{TextComponents.number((double)(drop.chance() * 100.0)).color(ChatFormatting.GOLD).string("%").color(ChatFormatting.GOLD).get()}).get());
            }
            if (!drop.tooltip().isEmpty()) {
                tooltips.add(TextComponents.translation((String)"oregrowth.jei_category.conditions").get());
                tooltips.addAll(drop.tooltip());
            }
            widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + x, startY + y)).entries(List.of(EntryStacks.of((ItemStack)drop.result()).tooltip(tooltips))).markOutput());
        }
        if (outputs <= 1) {
            startX += 9;
        }
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)BACKGROUND, (int)(startX + 37), (int)(startY + 20), (float)111.0f, (float)0.0f, (int)32, (int)15));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(startX + 43, startY + 18)).entry(EntryStacks.of((ItemLike)Items.f_42390_)).notInteractable().disableBackground().disableHighlight().disableTooltips());
        final Function<EntryStack, Block> baseGetter = entry -> Optional.ofNullable(entry).map(EntryStack::getValue).map(ItemStack::m_41720_).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).m_40614_()).orElse(null);
        final Slot baseSlot = Widgets.createSlot((Rectangle)new Rectangle(startX + 2, startY + 24, 30, 30)).entries(recipe.bases((HolderLookup<Block>)HolderLookup.m_235701_((Registry)Registry.f_122824_)).stream().map(EntryStacks::of).map(entry -> {
            final EntryRenderer originalRenderer = entry.getRenderer();
            return entry.withRenderer((EntryRenderer)new EntryRenderer<ItemStack>(){

                public void render(EntryStack<ItemStack> entry, PoseStack poseStack, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    Block base = (Block)baseGetter.apply(entry);
                    if (base != null) {
                        poseStack.m_85836_();
                        poseStack.m_85837_((double)bounds.x, (double)bounds.y, -100.0);
                        OreGrowthREIRecipeCategory.renderModel(poseStack, base.m_49966_(), 6, 6, 0, ModelData.EMPTY);
                        poseStack.m_85849_();
                    }
                }

                @Nullable
                public Tooltip getTooltip(EntryStack<ItemStack> entry, TooltipContext context) {
                    return originalRenderer.getTooltip(entry, context);
                }
            });
        }).toList()).disableBackground().markInput();
        widgets.add((Widget)baseSlot);
        widgets.add((Widget)Widgets.wrapRenderer((Rectangle)new Rectangle(startX + 2, startY + 8, 30, 30), (Renderer)new AbstractRenderer(){

            public void render(PoseStack poseStack, Rectangle bounds, int mouseX, int mouseY, float delta) {
                Block base = (Block)baseGetter.apply(baseSlot.getCurrentEntry().cast());
                if (base != null) {
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)bounds.x, (double)bounds.y, 0.0);
                    int stage = (int)(System.currentTimeMillis() / 1200L % (long)recipe.stages() + 1L);
                    BlockState state = (BlockState)OreGrowth.ORE_GROWTH_BLOCK.m_49966_().m_61124_((Property)OreGrowthBlock.STAGE, (Comparable)Integer.valueOf(stage));
                    ModelData modelData = ModelData.builder().with(OreGrowthBlockBakedModel.BASE_BLOCK_PROPERTY, (Object)base).build();
                    OreGrowthREIRecipeCategory.renderModel(poseStack, state, 7, 7, 10, modelData);
                    poseStack.m_85849_();
                }
            }
        }));
        return widgets;
    }

    private static void renderModel(PoseStack poseStack, BlockState state, int x, int y, int offset, ModelData modelData) {
        boolean blockLight;
        ClientUtils.getTextureManager().m_118506_(TextureAtlases.getBlocks()).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlases.getBlocks());
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(poseStack.m_85850_().m_85861_());
        modelViewStack.m_85837_((double)(x + 8), (double)(y + 8), (double)(150 + offset));
        modelViewStack.m_85841_(1.85f, 1.85f, 1.85f);
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        boolean bl = blockLight = !model.m_7547_();
        if (blockLight) {
            Lighting.m_84930_();
        }
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_85845_(new Quaternion(30.0f, 225.0f, 0.0f, true));
        poseStack2.m_85841_(0.625f, 0.625f, 0.625f);
        poseStack2.m_85837_(-0.5, -0.5, -0.5);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        RANDOM.m_188584_(42L);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, RANDOM, modelData);
        RenderType renderType = renderTypes.contains(RenderType.m_110466_()) ? Sheets.m_110792_() : Sheets.m_110790_();
        ClientUtils.getBlockRenderer().renderSingleBlock(state, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
        bufferSource.m_109911_();
        if (blockLight) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

