/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.OreGrowthConfig;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlock
extends BaseBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_STAGES = 4;
    public static IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)1, (int)4);
    public static EnumProperty<Direction> FACE = BlockStateProperties.f_61372_;
    public static BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static BooleanProperty REQUIRES_TOOL_FOR_DROPS = BooleanProperty.m_61465_((String)"requires_tool_for_drops");
    public static EnumProperty<HarvestTool> HARVEST_TOOL = EnumProperty.m_61587_((String)"harvest_tool", HarvestTool.class);
    public static EnumProperty<ToolTier> TOOL_TIER = EnumProperty.m_61587_((String)"tool_tier", ToolTier.class);
    private static final BlockShape[] SHAPES = new BlockShape[]{BlockShape.createBlockShape((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), BlockShape.createBlockShape((double)5.8, (double)0.0, (double)5.8, (double)10.2, (double)7.0, (double)10.2), BlockShape.createBlockShape((double)5.2, (double)0.0, (double)5.2, (double)10.8, (double)9.0, (double)10.8), BlockShape.createBlockShape((double)5.1, (double)0.0, (double)5.1, (double)10.9, (double)11.0, (double)10.9)};
    private static final BlockShape[] SHAPES_ROTATED = new BlockShape[SHAPES.length * 6];

    public static void trySpawnOreGrowth(BlockBehaviour.BlockStateBase base, OreGrowthRecipe recipe, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((double)random.m_188501_() > recipe.spawnChance() * OreGrowthConfig.spawnChanceScalar.get()) {
            return;
        }
        Direction side = Direction.values()[random.m_188503_(Direction.values().length)];
        BlockPos growthPos = pos.m_121945_(side);
        BlockState currentState = level.m_8055_(growthPos);
        if (!currentState.m_60795_() && !currentState.m_60713_(Blocks.f_49990_)) {
            return;
        }
        OreGrowthBlock block = recipe.stages() > 1 ? OreGrowth.ORE_GROWTH_BLOCK : OreGrowth.COMPLETE_ORE_GROWTH_BLOCK;
        BlockState state = (BlockState)((BlockState)OreGrowthBlock.propertiesForBase(block.m_49966_(), base).m_61124_(FACE, (Comparable)side.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(currentState.m_60819_().m_76152_() == Fluids.f_76193_));
        level.m_46597_(growthPos, state);
    }

    private static BlockState propertiesForBase(BlockState state, BlockBehaviour.BlockStateBase base) {
        HarvestTool harvestTool;
        HarvestTool harvestTool2 = base.m_204336_(BlockTags.f_144282_) ? HarvestTool.PICKAXE : (base.m_204336_(BlockTags.f_144280_) ? HarvestTool.AXE : (base.m_204336_(BlockTags.f_144283_) ? HarvestTool.SHOVEL : (harvestTool = base.m_204336_(BlockTags.f_144281_) ? HarvestTool.HOE : HarvestTool.NONE)));
        ToolTier toolTier = base.m_204336_(BlockTags.f_144284_) ? ToolTier.DIAMOND : (base.m_204336_(BlockTags.f_144285_) ? ToolTier.IRON : (base.m_204336_(BlockTags.f_144286_) ? ToolTier.STONE : ToolTier.NONE));
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)REQUIRES_TOOL_FOR_DROPS, (Comparable)Boolean.valueOf(base.m_60834_()))).m_61124_(HARVEST_TOOL, (Comparable)((Object)harvestTool))).m_61124_(TOOL_TIER, (Comparable)((Object)toolTier));
    }

    private static BlockState copyProperties(BlockState from, Block to) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)to.m_49966_().m_61124_((Property)STAGE, (Comparable)((Integer)from.m_61143_((Property)STAGE)))).m_61124_(FACE, (Comparable)((Direction)from.m_61143_(FACE)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)from.m_61143_((Property)WATERLOGGED)))).m_61124_((Property)REQUIRES_TOOL_FOR_DROPS, (Comparable)((Boolean)from.m_61143_((Property)REQUIRES_TOOL_FOR_DROPS)))).m_61124_(HARVEST_TOOL, (Comparable)((Object)((HarvestTool)((Object)from.m_61143_(HARVEST_TOOL)))))).m_61124_(TOOL_TIER, (Comparable)((Object)((ToolTier)((Object)from.m_61143_(TOOL_TIER)))));
    }

    public OreGrowthBlock() {
        super(false, BlockProperties.create((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76398_).lootTable(BuiltInLootTables.f_78712_).randomTicks().destroyTime(0.5f).explosionResistance(0.5f).sound(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1))).m_61124_(FACE, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)REQUIRES_TOOL_FOR_DROPS, (Comparable)Boolean.valueOf(false))).m_61124_(HARVEST_TOOL, (Comparable)((Object)HarvestTool.NONE))).m_61124_(TOOL_TIER, (Comparable)((Object)ToolTier.NONE)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState base = level.m_8055_(pos.m_121945_((Direction)state.m_61143_(FACE)));
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.f_46443_).getRecipeFor(base.m_60734_());
        if (recipe == null) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return;
        }
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (this == OreGrowth.ORE_GROWTH_BLOCK) {
            if (stage == recipe.stages()) {
                level.m_46597_(pos, OreGrowthBlock.copyProperties(OreGrowthBlock.propertiesForBase(state, (BlockBehaviour.BlockStateBase)base), (Block)OreGrowth.COMPLETE_ORE_GROWTH_BLOCK));
                return;
            }
            if (stage < recipe.stages() && (double)random.m_188501_() < recipe.growthChance() * OreGrowthConfig.growthChanceScalar.get()) {
                if (stage + 1 == recipe.stages()) {
                    state = OreGrowthBlock.copyProperties(state, (Block)OreGrowth.COMPLETE_ORE_GROWTH_BLOCK);
                }
                level.m_46597_(pos, (BlockState)OreGrowthBlock.propertiesForBase(state, (BlockBehaviour.BlockStateBase)base).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            }
        } else if (stage < recipe.stages()) {
            level.m_46597_(pos, OreGrowthBlock.copyProperties(OreGrowthBlock.propertiesForBase(state, (BlockBehaviour.BlockStateBase)base), (Block)OreGrowth.ORE_GROWTH_BLOCK));
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ServerLevel level = builder.m_78962_();
        if (level == null) {
            return Collections.emptyList();
        }
        Vec3 origin = (Vec3)builder.m_78970_(LootContextParams.f_81460_);
        BlockPos pos = new BlockPos((int)Math.floor(origin.f_82479_), (int)Math.floor(origin.f_82480_), (int)Math.floor(origin.f_82481_));
        Direction facing = (Direction)state.m_61143_(FACE);
        BlockState base = level.m_8055_(pos.m_121945_(facing));
        ItemStack tool = (ItemStack)builder.m_78982_(LootContextParams.f_81463_);
        Entity entity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
        if (tool != null ? !tool.m_41735_(state) : (entity instanceof Player ? !ForgeHooks.isCorrectToolForDrops((BlockState)base, (Player)((Player)entity)) : (entity instanceof LivingEntity ? !((LivingEntity)entity).m_21205_().m_41735_(base) : base.m_60834_()))) {
            return Collections.emptyList();
        }
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.f_46443_).getRecipeFor(base.m_60734_());
        if (recipe == null) {
            return Collections.emptyList();
        }
        LootContext lootParams = builder.m_78972_(LootContextParams.f_81461_, (Object)state).m_78975_(LootContextParamSets.f_81421_);
        return recipe.generateDrops(state, (Integer)state.m_61143_((Property)STAGE), lootParams);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        pos = pos.m_121945_((Direction)state.m_61143_(FACE));
        return level.m_8055_(pos).m_60625_(player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        Direction facing = (Direction)state.m_61143_(FACE);
        Block base = level.m_8055_(pos.m_121945_(facing)).m_60734_();
        return base.getSoundType(state, level, pos, entity);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        Block base = level.m_8055_(pos.m_121945_((Direction)state.m_61143_(FACE))).m_60734_();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.f_46443_).getRecipeFor(base);
        if (recipe == null) {
            return 0;
        }
        int stage = (Integer)state.m_61143_((Property)STAGE);
        return (int)Math.floor((double)stage / (double)recipe.stages() * 15.0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES_ROTATED[((Integer)state.m_61143_((Property)STAGE) - 1) * 6 + ((Direction)state.m_61143_(FACE)).ordinal()].getUnderlying();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE, FACE, WATERLOGGED, REQUIRES_TOOL_FOR_DROPS, HARVEST_TOOL, TOOL_TIER});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_().m_122424_();
        Level level = context.m_43725_();
        BlockState base = level.m_8055_(context.m_8083_().m_121945_(face));
        OreGrowthRecipe recipe = OreGrowthRecipeManager.get(level.f_46443_).getRecipeFor(base.m_60734_());
        if (recipe == null) {
            return null;
        }
        BlockState state = (BlockState)((BlockState)OreGrowthBlock.propertiesForBase(this.m_49966_(), (BlockBehaviour.BlockStateBase)base).m_61124_(FACE, (Comparable)face)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        if (this == OreGrowth.COMPLETE_ORE_GROWTH_BLOCK) {
            state = (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(recipe.stages()));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction neighborDirection, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (state.m_60734_() != this || !this.m_7898_(state, (LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return OreGrowthBlock.propertiesForBase(state, (BlockBehaviour.BlockStateBase)level.m_8055_(pos.m_121945_((Direction)state.m_61143_(FACE))));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(FACE);
        return OreGrowthRecipeManager.get(level.m_5776_()).getRecipeFor(level.m_8055_(pos.m_121945_(facing)).m_60734_()) != null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean requiresCorrectToolForDrops(BlockBehaviour.BlockStateBase state) {
        return (Boolean)state.m_61143_((Property)REQUIRES_TOOL_FOR_DROPS);
    }

    public boolean is(BlockBehaviour.BlockStateBase state, TagKey<Block> tag) {
        return tag.equals(((HarvestTool)((Object)state.m_61143_(OreGrowthBlock.HARVEST_TOOL))).tag) || tag.equals(((ToolTier)((Object)state.m_61143_(OreGrowthBlock.TOOL_TIER))).tag);
    }

    static {
        for (int stage = 0; stage < 4; ++stage) {
            BlockShape shape = SHAPES[stage];
            for (Direction face : Direction.values()) {
                OreGrowthBlock.SHAPES_ROTATED[stage * 6 + face.ordinal()] = face == Direction.UP ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X) : (face == Direction.NORTH ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y) : (face == Direction.EAST ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y) : (face == Direction.SOUTH ? shape.rotate(Direction.Axis.X) : (face == Direction.WEST ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y) : shape))));
            }
        }
    }

    public static enum HarvestTool implements StringRepresentable
    {
        NONE(null),
        AXE((TagKey<Block>)BlockTags.f_144280_),
        HOE((TagKey<Block>)BlockTags.f_144281_),
        PICKAXE((TagKey<Block>)BlockTags.f_144282_),
        SHOVEL((TagKey<Block>)BlockTags.f_144283_);

        private final TagKey<Block> tag;

        private HarvestTool(TagKey<Block> tag) {
            this.tag = tag;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum ToolTier implements StringRepresentable
    {
        NONE(null),
        STONE((TagKey<Block>)BlockTags.f_144286_),
        IRON((TagKey<Block>)BlockTags.f_144285_),
        DIAMOND((TagKey<Block>)BlockTags.f_144284_);

        private final TagKey<Block> tag;

        private ToolTier(TagKey<Block> tag) {
            this.tag = tag;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

