/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.util.Pair;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;

public class OreGrowthRecipeManager {
    private static final OreGrowthRecipeManager SERVER = new OreGrowthRecipeManager();
    private static final OreGrowthRecipeManager CLIENT = new OreGrowthRecipeManager();
    private RecipeManager recipeManager;
    private HolderLookup<Block> blockLookup;
    private boolean reload = true;
    private Map<Block, OreGrowthRecipe> recipesByBlock = Collections.emptyMap();

    public static OreGrowthRecipeManager get(boolean isClient) {
        return isClient ? CLIENT : SERVER;
    }

    public synchronized void reloadRecipes(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
        this.blockLookup = HolderLookup.m_235701_((Registry)Registry.f_122824_);
        this.reload = true;
        this.recipesByBlock = Collections.emptyMap();
    }

    public OreGrowthRecipe getRecipeFor(Block block) {
        this.cacheRecipes();
        return this.recipesByBlock.get(block);
    }

    public List<OreGrowthRecipe> getAllRecipes() {
        this.cacheRecipes();
        return Arrays.asList((OreGrowthRecipe[])this.recipesByBlock.values().toArray(OreGrowthRecipe[]::new));
    }

    private synchronized void cacheRecipes() {
        if (this.reload && this.recipeManager != null) {
            this.recipesByBlock = this.recipeManager.f_44007_.getOrDefault(OreGrowth.ORE_GROWTH_RECIPE_TYPE, Collections.emptyMap()).values().stream().map(OreGrowthRecipe.class::cast).sorted(Comparator.comparing(recipe -> recipe.m_6423_().toString())).flatMap(recipe -> recipe.bases(this.blockLookup).stream().map(block -> Pair.of((Object)block, (Object)recipe))).collect(Collectors.toUnmodifiableMap(Pair::left, Pair::right, (recipe, recipe2) -> recipe));
            this.reload = false;
        }
    }
}

