package io.github.gameking1happy.gk1hrecipes.data;

import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.*;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;

import static io.github.gameking1happy.gk1hcore.Main.fNAP;
import static io.github.gameking1happy.gk1hrecipes.Main.MOD_ID;

public class NetheriteRecipeProvider extends RecipeProvider {
    // Get the parameters from GatherDataEvent.
    public NetheriteRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }
    @Override
    public @NotNull String getName() {
        return super.getName() + "-Netherite";
    }
    @Override
    protected void buildRecipes(@NotNull RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.NETHERITE_INGOT)
                .requires(Items.GOLD_INGOT)
                .requires(Items.NETHER_STAR)
                .group("netherite_ingot")
                .unlockedBy("has_gold_ingot",has(Items.GOLD_INGOT))
                .unlockedBy("has_nether_star", has(Items.NETHER_STAR))
                .save(output,fNAP(MOD_ID,"netherite"));
    }
}