/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions;

import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Utils;
import io.github.mqzen.menus.base.Menu;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Action {
    private static final Pattern SPLITTER = Pattern.compile("^([A-z])*(?=(\\{.*}))");
    private List<Condition> conditions = new ArrayList<Condition>();
    private int delay = 0;
    private Condition.SelectionMode mode = Condition.SelectionMode.ONE;
    private int cooldown = 0;
    private Map<UUID, Instant> cooldowns = new ConcurrentHashMap<UUID, Instant>();

    public Action() {
    }

    public Action(int delay, Condition.SelectionMode mode, List<Condition> conditions, int cooldown) {
        this.delay = delay;
        this.mode = mode;
        this.conditions = conditions;
        this.cooldown = cooldown;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Action(int delay, Condition.SelectionMode mode, List<Condition> conditions) {
        this(delay, mode, conditions, 0);
    }

    protected static List<Condition> deserializeConditions(String json) {
        String data = Action.parseArray(json, "conditions").replace("},]", "}]");
        return (List)CustomNPCs.getGson().fromJson(data, Utils.CONDITIONS_LIST);
    }

    @Nullable
    public static Action parse(@NotNull String s) {
        Matcher matcher = SPLITTER.matcher(s);
        if (matcher.find()) {
            String type = matcher.group();
            Class<? extends Action> clazz = CustomNPCs.ACTION_REGISTRY.getActionClass(type);
            if (clazz == null) {
                CustomNPCs.getInstance().getLogger().severe("Unknown action class " + type);
                return null;
            }
            Class[] parameterTypes = new Class[]{String.class, Class.class};
            Method method = clazz.getMethod("deserialize", parameterTypes);
            Object result = method.invoke(null, s, clazz);
            return (Action)result;
        }
        return null;
    }

    protected static ParseResult parseBase(String data) {
        int cooldown = Action.parseInt(data, "cooldown");
        int delay = Action.parseInt(data, "delay");
        Condition.SelectionMode mode = Action.parseEnum(data, "mode", Condition.SelectionMode.class);
        List<Condition> conditions = Action.deserializeConditions(Action.parseString(data, "conditions"));
        return new ParseResult(delay, mode, conditions, cooldown);
    }

    protected static <T extends Enum<T>> T parseEnum(String data, String key, Class<T> type) {
        String constantName = data.replaceAll(".*" + key + "=([A-Z_]+).*", "$1");
        return Enum.valueOf(type, constantName);
    }

    protected static int parseInt(String data, String key) {
        try {
            return Integer.parseInt(data.replaceAll(".*" + key + "=(\\d+).*", "$1"));
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    protected static String parseString(String data, String key) {
        return data.replaceAll(".*" + key + "=`(.*?)`.*", "$1");
    }

    protected static String parseArray(String data, String key) {
        return data.replaceAll(".*" + key + "=(\\[.*?]).*", "$1");
    }

    protected static boolean parseBoolean(String data, String key) {
        return Boolean.parseBoolean(data.replaceAll(".*" + key + "=(true|false).*", "$1"));
    }

    protected static float parseFloat(String data, String key) {
        return Float.parseFloat(data.replaceAll(".*" + key + "=(-?\\d+\\.\\d+).*", "$1"));
    }

    protected static double parseDouble(String data, String key) {
        return Double.parseDouble(data.replaceAll(".*" + key + "=(-?\\d+\\.\\d+).*", "$1"));
    }

    public boolean isOnCooldown(UUID uuid) {
        if (!this.cooldowns.containsKey(uuid)) {
            return false;
        }
        Instant i = this.cooldowns.get(uuid);
        if (i.isBefore(Instant.now())) {
            this.cooldowns.remove(uuid);
            return false;
        }
        return true;
    }

    public void activateCooldown(UUID uuid) {
        if (this.cooldown == 0) {
            return;
        }
        this.cooldowns.put(uuid, Instant.now().plusMillis(50L * (long)this.cooldown));
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void removeCondition(Condition condition) {
        this.conditions.remove(condition);
    }

    public abstract void perform(InternalNpc var1, Menu var2, Player var3);

    public abstract String serialize();

    public abstract ItemStack getFavicon(Player var1);

    public String toString() {
        return this.serialize();
    }

    public abstract Menu getMenu();

    public boolean processConditions(Player player) {
        if (this.isOnCooldown(player.getUniqueId())) {
            return false;
        }
        if (this.conditions == null || this.conditions.isEmpty()) {
            return true;
        }
        HashSet results = new HashSet(this.conditions.size());
        this.conditions.forEach(conditional -> results.add(conditional.compute(player)));
        return this.mode == Condition.SelectionMode.ALL ? !results.contains(false) : results.contains(true);
    }

    private String getConditionSerialized() {
        return CustomNPCs.getGson().toJson(this.conditions, Utils.CONDITIONS_LIST);
    }

    protected String generateSerializedString(String id, Map<String, Object> params) {
        Object value;
        String key;
        HashMap<String, Object> base = new HashMap<String, Object>();
        base.put("delay", this.delay);
        base.put("mode", (Object)this.mode);
        base.put("conditions", this.getConditionSerialized());
        base.put("cooldown", this.cooldown);
        StringBuilder builder = new StringBuilder(id);
        builder.append("{");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            builder.append(key).append("=");
            if (value instanceof String) {
                builder.append("`").append(value).append("`");
            } else {
                builder.append(value);
            }
            builder.append(", ");
        }
        for (Map.Entry<String, Object> entry : base.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            builder.append(key).append("=");
            if (value instanceof String) {
                builder.append("`").append(value).append("`");
            } else {
                builder.append(value);
            }
            builder.append(", ");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.deleteCharAt(builder.length() - 1);
        builder.append("}");
        return builder.toString();
    }

    public abstract Action clone();

    @Generated
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    @Generated
    public Condition.SelectionMode getMode() {
        return this.mode;
    }

    @Generated
    public int getCooldown() {
        return this.cooldown;
    }

    @Generated
    public Map<UUID, Instant> getCooldowns() {
        return this.cooldowns;
    }

    @Generated
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @Generated
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Generated
    public void setMode(Condition.SelectionMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Generated
    public void setCooldowns(Map<UUID, Instant> cooldowns) {
        this.cooldowns = cooldowns;
    }

    protected record ParseResult(int delay, Condition.SelectionMode mode, List<Condition> conditions, int cooldown) {
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="1.9")
        public ParseResult(int delay, Condition.SelectionMode mode, List<Condition> conditions) {
            this(delay, mode, conditions, 0);
        }
    }
}

