/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.ActionType;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.actions.defaultImpl.ActionBar;
import dev.foxikle.customnpcs.actions.defaultImpl.DisplayTitle;
import dev.foxikle.customnpcs.actions.defaultImpl.GiveEffect;
import dev.foxikle.customnpcs.actions.defaultImpl.GiveXP;
import dev.foxikle.customnpcs.actions.defaultImpl.PlaySound;
import dev.foxikle.customnpcs.actions.defaultImpl.RemoveEffect;
import dev.foxikle.customnpcs.actions.defaultImpl.RemoveXP;
import dev.foxikle.customnpcs.actions.defaultImpl.RunCommand;
import dev.foxikle.customnpcs.actions.defaultImpl.SendMessage;
import dev.foxikle.customnpcs.actions.defaultImpl.SendServer;
import dev.foxikle.customnpcs.actions.defaultImpl.Teleport;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="1.9.0")
public class LegacyAction {
    private final ActionType actionType;
    private final List<String> args;
    private final List<Condition> conditionals;
    private int delay;
    private Condition.SelectionMode mode;

    public LegacyAction(ActionType actionType, List<String> args, int delay, Condition.SelectionMode matchAll, List<Condition> conditionals) {
        this.actionType = actionType;
        this.args = args;
        this.delay = delay;
        this.mode = matchAll;
        this.conditionals = conditionals;
    }

    private LegacyAction(String subCommand, ArrayList<String> args, int delay) {
        this.actionType = ActionType.valueOf(subCommand);
        this.args = args;
        this.delay = delay;
        this.mode = Condition.SelectionMode.ONE;
        this.conditionals = new ArrayList<Condition>();
    }

    public static LegacyAction of(String string) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        if (string.contains("%::%")) {
            ArrayList<String> split = new ArrayList<String>(Arrays.stream(string.split("%::%")).toList());
            String sub = split.get(0);
            split.remove(0);
            int delay = Integer.parseInt(split.get(0));
            split.remove(0);
            return new LegacyAction(sub, split, delay);
        }
        return (LegacyAction)CustomNPCs.getGson().fromJson(string, LegacyAction.class);
    }

    public List<String> getArgsCopy() {
        return new ArrayList<String>(this.args);
    }

    public boolean addConditional(Condition conditional) {
        return this.conditionals.add(conditional);
    }

    public boolean removeConditional(Condition conditional) {
        return this.conditionals.remove(conditional);
    }

    public String getCommand(@NotNull Player player) {
        if (this.processConditions(player)) {
            return "npcaction " + String.valueOf(player.getUniqueId()) + " " + this.actionType.name() + " " + this.delay + " " + String.join((CharSequence)" ", this.args);
        }
        return "npcaction";
    }

    private boolean processConditions(Player player) {
        if (this.conditionals == null || this.conditionals.isEmpty()) {
            return true;
        }
        HashSet results = new HashSet(2);
        this.conditionals.forEach(conditional -> results.add(conditional.compute(player)));
        return this.mode == Condition.SelectionMode.ALL ? !results.contains(false) : results.contains(true);
    }

    public String toJson() {
        return CustomNPCs.getGson().toJson((Object)this);
    }

    public LegacyAction clone() {
        return new LegacyAction(this.actionType, this.args, this.delay, this.mode, this.conditionals);
    }

    @Nullable
    public Action toAction() {
        return switch (this.actionType) {
            default -> throw new IncompatibleClassChangeError();
            case ActionType.ACTION_BAR -> new ActionBar(String.join((CharSequence)" ", this.args), this.delay, this.mode, this.conditionals, 0);
            case ActionType.SEND_MESSAGE -> new SendMessage(String.join((CharSequence)" ", this.args), this.delay, this.mode, this.conditionals, 0);
            case ActionType.DISPLAY_TITLE -> new DisplayTitle(String.join((CharSequence)" ", this.args.subList(3, this.args.size() - 1)), "", Integer.parseInt(this.args.get(0)), Integer.parseInt(this.args.get(1)), Integer.parseInt(this.args.get(2)), this.delay, this.mode, this.conditionals, 0);
            case ActionType.RUN_COMMAND -> new RunCommand(String.join((CharSequence)" ", this.args), false, this.delay, this.mode, this.conditionals, 0);
            case ActionType.TELEPORT -> new Teleport(Double.parseDouble(this.args.get(0)), Double.parseDouble(this.args.get(1)), Double.parseDouble(this.args.get(2)), Float.parseFloat(this.args.get(3)), Float.parseFloat(this.args.get(4)), this.delay, this.mode, this.conditionals, 0);
            case ActionType.GIVE_EXP -> new GiveXP(Integer.parseInt(this.args.get(0)), Boolean.parseBoolean(this.args.get(1)), this.delay, this.mode, this.conditionals, 0);
            case ActionType.ADD_EFFECT -> new GiveEffect(this.args.get(3), Integer.parseInt(this.args.get(0)), Integer.parseInt(this.args.get(1)), Boolean.parseBoolean(this.args.get(2)), this.delay, this.mode, this.conditionals, 0);
            case ActionType.PLAY_SOUND -> new PlaySound(this.args.get(2), Float.parseFloat(this.args.get(1)), Float.parseFloat(this.args.get(0)), this.delay, this.mode, this.conditionals, 0);
            case ActionType.REMOVE_EXP -> new RemoveXP(Integer.parseInt(this.args.get(0)), Boolean.parseBoolean(this.args.get(1)), this.delay, this.mode, this.conditionals, 0);
            case ActionType.REMOVE_EFFECT -> new RemoveEffect(this.args.get(0), this.delay, this.mode, this.conditionals, 0);
            case ActionType.SEND_TO_SERVER -> new SendServer(String.join((CharSequence)" ", this.args), this.delay, this.mode, this.conditionals, 0);
            case ActionType.TOGGLE_FOLLOWING -> throw new IllegalArgumentException("Toggle following is no longer supported");
        };
    }

    @Generated
    public ActionType getActionType() {
        return this.actionType;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public List<Condition> getConditionals() {
        return this.conditionals;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    @Generated
    public Condition.SelectionMode getMode() {
        return this.mode;
    }

    @Generated
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Generated
    public void setMode(Condition.SelectionMode mode) {
        this.mode = mode;
    }
}

