/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.conditions;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.actions.conditions.LogicalCondition;
import dev.foxikle.customnpcs.actions.conditions.NumericCondition;
import java.io.IOException;

public class ConditionalTypeAdapter
extends TypeAdapter<Condition> {
    public void write(JsonWriter out, Condition conditional) throws IOException {
        out.beginObject();
        out.name("type").value(conditional.getType().toString());
        out.name("value").value(conditional.getValue().toString());
        out.name("comparator").value(conditional.getComparator().toString());
        out.name("target").value(conditional.getTarget());
        out.endObject();
    }

    public Condition read(JsonReader in) throws IOException {
        in.beginObject();
        Condition.Type type = null;
        Condition.Value value = null;
        Condition.Comparator comparator = null;
        String targetValue = null;
        block12: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "type": {
                    type = Condition.Type.valueOf(in.nextString());
                    continue block12;
                }
                case "value": {
                    value = Condition.Value.valueOf(in.nextString());
                    continue block12;
                }
                case "comparator": {
                    comparator = Condition.Comparator.valueOf(in.nextString());
                    continue block12;
                }
                case "target": {
                    targetValue = in.nextString();
                    continue block12;
                }
            }
            in.skipValue();
        }
        in.endObject();
        Condition conditional = null;
        if (type != null && value != null && comparator != null && targetValue != null) {
            if (type == Condition.Type.NUMERIC) {
                conditional = new NumericCondition(comparator, value, Double.parseDouble(targetValue));
            } else if (type == Condition.Type.LOGICAL) {
                conditional = new LogicalCondition(comparator, value, targetValue);
            }
        }
        return conditional;
    }
}

