/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.conditions;

import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import java.util.Objects;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="1.8.0")
public class LogicalConditional
implements Condition {
    private final Condition.Type type = Condition.Type.LOGICAL;
    private Condition.Comparator comparator;
    private Condition.Value value;
    private String target;

    public LogicalConditional(Condition.Comparator comparator, Condition.Value value, String target) {
        this.comparator = comparator;
        this.value = value;
        this.target = target;
    }

    @Override
    public boolean compute(Player player) {
        boolean value = false;
        switch (this.value) {
            case HAS_PERMISSION: {
                value = player.hasPermission(this.target);
                break;
            }
            case HAS_EFFECT: {
                value = player.hasPotionEffect(Objects.requireNonNull(PotionEffectType.getByName((String)this.target)));
                break;
            }
            case GAMEMODE: {
                value = player.getGameMode().equals((Object)GameMode.valueOf((String)this.target));
                break;
            }
            case IS_FLYING: {
                value = player.isFlying();
                break;
            }
            case IS_SPRINTING: {
                value = player.isSprinting();
                break;
            }
            case IS_SNEAKING: {
                value = player.isSneaking();
                break;
            }
            case IS_FROZEN: {
                value = player.isFrozen();
                break;
            }
            case IS_GLIDING: {
                value = player.isGliding();
            }
        }
        switch (this.comparator) {
            case EQUAL_TO: {
                return value;
            }
            case NOT_EQUAL_TO: {
                return !value;
            }
        }
        return false;
    }

    @Override
    public String toJson() {
        return CustomNPCs.getGson().toJson((Object)this);
    }

    public static LogicalConditional of(String data) {
        return (LogicalConditional)CustomNPCs.getGson().fromJson(data, LogicalConditional.class);
    }

    @Override
    public Condition.Type getType() {
        return this.type;
    }

    @Override
    public void setComparator(Condition.Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public void setValue(Condition.Value value) {
        this.value = value;
    }

    @Override
    public void setTargetValue(String targetValue) {
        this.target = targetValue;
    }

    @Override
    public Condition.Value getValue() {
        return this.value;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public Condition clone() {
        try {
            return (LogicalConditional)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new LogicalConditional(this.comparator, this.value, this.target);
        }
    }

    @Override
    public Condition.Comparator getComparator() {
        return this.comparator;
    }
}

