/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.runnables.SubtitleRunnable;
import dev.foxikle.customnpcs.internal.runnables.TitleRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DisplayTitle
extends Action {
    private String title;
    private String subTitle;
    private int fadeIn;
    private int stay;
    private int fadeOut;

    public DisplayTitle(String title, String subTitle, int fadeIn, int stay, int fadeOut, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.title = title;
        this.subTitle = subTitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public DisplayTitle(String title, String subTitle, int fadeIn, int stay, int fadeOut, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.title = title;
        this.subTitle = subTitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_SIGN).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.title", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.title.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            DisplayTitle actionImpl = new DisplayTitle("Title", "Subtitle", 10, 10, 10, 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(DisplayTitle.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + DisplayTitle.class.getName());
        }
        String title = DisplayTitle.parseString(serialized, "title");
        String subTitle = DisplayTitle.parseString(serialized, "subTitle");
        int in = DisplayTitle.parseInt(serialized, "in");
        int stay = DisplayTitle.parseInt(serialized, "stay");
        int out = DisplayTitle.parseInt(serialized, "out");
        Action.ParseResult pr = DisplayTitle.parseBase(serialized);
        DisplayTitle message = new DisplayTitle(title, subTitle, in, stay, out, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_SIGN).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.title", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format("<dark_aqua><st>                                    "), Msg.translate(player.locale(), "customnpcs.favicons.preview", new Object[0]), Msg.format("<white><!i>" + this.getTitle()), Msg.format("<white><!i>" + this.getSubTitle()), Msg.format("<dark_aqua><st>                                    "), Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_in", this.fadeIn), Msg.translate(player.locale(), "customnpcs.menus.action.title.display.stay", this.stay), Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_out", this.fadeOut), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public Menu getMenu() {
        return new DisplayTitleCustomizer(this);
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        Component titleComponent = CustomNPCs.getInstance().miniMessage.deserialize((Object)(CustomNPCs.getInstance().papi ? PlaceholderAPI.setPlaceholders((Player)player, (String)this.title) : this.title));
        Component subtitleComponent = CustomNPCs.getInstance().miniMessage.deserialize((Object)(CustomNPCs.getInstance().papi ? PlaceholderAPI.setPlaceholders((Player)player, (String)this.subTitle) : this.subTitle));
        player.showTitle(Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)this.fadeIn * 50L), (Duration)Duration.ofMillis((long)this.stay * 50L), (Duration)Duration.ofMillis((long)this.fadeOut * 50L))));
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", this.title);
        params.put("subTitle", this.subTitle);
        params.put("in", this.fadeIn);
        params.put("stay", this.stay);
        params.put("out", this.fadeOut);
        return this.generateSerializedString("DisplayTitle", params);
    }

    @Override
    public Action clone() {
        return new DisplayTitle(this.title, this.subTitle, this.fadeIn, this.stay, this.fadeOut, this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getSubTitle() {
        return this.subTitle;
    }

    @Generated
    public int getFadeIn() {
        return this.fadeIn;
    }

    @Generated
    public int getStay() {
        return this.stay;
    }

    @Generated
    public int getFadeOut() {
        return this.fadeOut;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    @Generated
    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    @Generated
    public void setStay(int stay) {
        this.stay = stay;
    }

    @Generated
    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    public static class DisplayTitleCustomizer
    implements Menu {
        private final DisplayTitle action;

        public DisplayTitleCustomizer(DisplayTitle action) {
            this.action = action;
        }

        public String getName() {
            return "DISPLAY_TITLE_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            Object[] incLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.increment.description", new Object[0]);
            Object[] decLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.decrement.description", new Object[0]);
            Component displayLore = Msg.translate(player.locale(), "customnpcs.menus.action.title.display.lore", new Object[0]);
            return MenuUtils.actionBase(this.action, player).setButton(10, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.fade_in.increase", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setFadeIn(this.action.getFadeIn() + 20);
                } else if (event.isLeftClick()) {
                    this.action.setFadeIn(this.action.getFadeIn() + 1);
                } else if (event.isRightClick()) {
                    this.action.setFadeIn(this.action.getFadeIn() + 5);
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_in", this.action.getFadeIn(), displayLore), new Component[0])));
            }))).setButton(12, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.stay.increase", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setStay(this.action.getStay() + 20);
                } else if (event.isLeftClick()) {
                    this.action.setStay(this.action.getStay() + 1);
                } else if (event.isRightClick()) {
                    this.action.setStay(this.action.getStay() + 5);
                }
                menuView.updateButton(21, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.stay", this.action.getStay(), displayLore), new Component[0])));
            }))).setButton(14, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.fade_out.increase", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setFadeOut(this.action.getFadeOut() + 20);
                } else if (event.isLeftClick()) {
                    this.action.setFadeOut(this.action.getFadeOut() + 1);
                } else if (event.isRightClick()) {
                    this.action.setFadeOut(this.action.getFadeOut() + 5);
                }
                menuView.updateButton(23, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_out", this.action.getFadeOut(), displayLore), new Component[0])));
            }))).setButton(19, Button.empty((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_in", this.action.fadeIn, displayLore), new Component[0]))).setButton(21, Button.empty((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.stay", this.action.stay, displayLore), new Component[0]))).setButton(23, Button.empty((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_out", this.action.fadeOut, displayLore), new Component[0]))).setButton(28, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.fade_in.decrease", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.fadeIn == 1) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.title.duration_less_than_1", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setFadeIn(Math.max(this.action.fadeIn - 20, 1));
                } else if (event.isLeftClick()) {
                    this.action.setFadeIn(Math.max(this.action.fadeIn - 1, 1));
                } else if (event.isRightClick()) {
                    this.action.setFadeIn(Math.max(this.action.fadeIn - 5, 1));
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_in", this.action.getFadeIn(), displayLore), new Component[0])));
            }))).setButton(30, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.stay.decrease", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.fadeIn == 1) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.title.duration_less_than_1", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setStay(Math.max(this.action.stay - 20, 1));
                } else if (event.isLeftClick()) {
                    this.action.setStay(Math.max(this.action.stay - 1, 1));
                } else if (event.isRightClick()) {
                    this.action.setStay(Math.max(this.action.stay - 5, 1));
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.stay", this.action.getStay(), displayLore), new Component[0])));
            }))).setButton(32, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.fade_out.decrease", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.fadeOut == 1) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.title.duration_less_than_1", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setFadeOut(Math.max(this.action.fadeOut - 20, 1));
                } else if (event.isLeftClick()) {
                    this.action.setFadeOut(Math.max(this.action.fadeOut - 1, 1));
                } else if (event.isRightClick()) {
                    this.action.setFadeOut(Math.max(this.action.fadeOut - 5, 1));
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.title.display.fade_out", this.action.getFadeOut(), displayLore), new Component[0])));
            }))).setButton(16, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_HANGING_SIGN).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.current.title", new Object[0]))).setLore((Object[])new Component[]{Msg.format("<white><!i>" + this.action.getTitle()), Component.empty(), Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                Player p = (Player)event.getWhoClicked();
                CustomNPCs plugin = CustomNPCs.getInstance();
                p.closeInventory();
                plugin.wait(p, WaitingType.TITLE);
                new TitleRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
            }))).setButton(34, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.DARK_OAK_HANGING_SIGN).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.title.current.subtitle", new Object[0]))).setLore((Object[])new Component[]{Msg.format("<white><!i>" + this.action.getSubTitle()), Component.empty(), Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                Player p = (Player)event.getWhoClicked();
                CustomNPCs plugin = CustomNPCs.getInstance();
                p.closeInventory();
                plugin.wait(p, WaitingType.SUBTITLE);
                new SubtitleRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
            }))).build();
        }
    }
}

