/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class RemoveEffect
extends Action {
    private static final List<Field> fields = Stream.of(PotionEffectType.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers())).toList();
    private String effect;

    public RemoveEffect(String effect, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.effect = effect;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public RemoveEffect(String effect, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.effect = effect;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.MILK_BUCKET).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.remove_effect", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.remove_effect.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            RemoveEffect actionImpl = new RemoveEffect("SPEED", 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(player.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(RemoveEffect.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + RemoveEffect.class.getName());
        }
        String effect = RemoveEffect.parseString(serialized, "effect");
        Action.ParseResult pr = RemoveEffect.parseBase(serialized);
        RemoveEffect message = new RemoveEffect(effect, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.MILK_BUCKET).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.remove_effect", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.give_effect.effect", this.effect), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public Menu getMenu() {
        return new RemoveEffectCustomizer(this);
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        if (PotionEffectType.getByName((String)this.effect) == null) {
            throw new NullPointerException("Effect " + this.effect + " does not exist? Please tell @foxikle on discord how you managed this.");
        }
        player.removePotionEffect(Objects.requireNonNull(PotionEffectType.getByName((String)this.effect)));
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        return this.generateSerializedString("RemoveEffect", Map.of("effect", this.effect));
    }

    @Override
    public Action clone() {
        return new RemoveEffect(this.effect, this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Generated
    public String getEffect() {
        return this.effect;
    }

    @Generated
    public void setEffect(String effect) {
        this.effect = effect;
    }

    public class RemoveEffectCustomizer
    implements Menu {
        private final RemoveEffect action;

        public RemoveEffectCustomizer(RemoveEffect action) {
            this.action = action;
        }

        public String getName() {
            return "REMOVE_EFFECT_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            return MenuUtils.actionBase(this.action, player).setButton(22, this.generateToggleEffect(player)).build();
        }

        private Button generateToggleEffect(Player player) {
            ArrayList lore = new ArrayList();
            fields.forEach(field -> {
                if (!Objects.equals(this.action.getEffect(), field.getName())) {
                    lore.add(Msg.format("<green>" + field.getName()));
                } else {
                    lore.add(Msg.format("<dark_aqua>\u25b8 " + field.getName()));
                }
            });
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.POTION).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.remove_effect.effect", new Object[0]))).addFlags(ItemFlag.values())).setLore((Object[])lore.toArray(new Component[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                ArrayList effects = new ArrayList();
                fields.forEach(field -> effects.add(field.getName()));
                int index = effects.indexOf(RemoveEffect.this.getEffect());
                if (event.isLeftClick()) {
                    if (effects.size() > index + 1) {
                        RemoveEffect.this.setEffect((String)effects.get(index + 1));
                    } else {
                        RemoveEffect.this.setEffect((String)effects.get(0));
                    }
                } else if (event.isRightClick()) {
                    if (index == 0) {
                        RemoveEffect.this.setEffect((String)effects.get(effects.size() - 1));
                    } else {
                        RemoveEffect.this.setEffect((String)effects.get(index - 1));
                    }
                }
                menuView.updateButton(22, button -> button.setItem(this.generateToggleEffect(player).getItem()));
            }));
        }
    }
}

