/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.runnables.MessageRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SendMessage
extends Action {
    private String rawMessage;

    public SendMessage(String rawMessage, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.rawMessage = rawMessage;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public SendMessage(String rawMessage, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals);
        this.rawMessage = rawMessage;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.PAPER).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.message", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.message.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            SendMessage actionImpl = new SendMessage("", 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(SendMessage.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + SendMessage.class.getName());
        }
        String rawMessage = SendMessage.parseString(serialized, "raw");
        Action.ParseResult pr = SendMessage.parseBase(serialized);
        SendMessage message = new SendMessage(rawMessage, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.PAPER).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.message", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format("<dark_aqua><st>                                    "), Msg.translate(player.locale(), "customnpcs.favicons.preview", new Object[0]), Msg.format((String)(this.getRawMessage().isEmpty() ? "<dark_gray><i>" + Msg.translatedString(player.locale(), "customnpcs.messages.empty_string", new Object[0]) : this.getRawMessage())), Msg.format("<dark_aqua><st>                                    "), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public Menu getMenu() {
        return new SendMessageCustomizer(this);
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        if (CustomNPCs.getInstance().papi) {
            player.sendMessage(CustomNPCs.getInstance().getMiniMessage().deserialize((Object)PlaceholderAPI.setPlaceholders((Player)player, (String)this.rawMessage)));
        } else {
            player.sendMessage(CustomNPCs.getInstance().getMiniMessage().deserialize((Object)this.rawMessage));
        }
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        return this.generateSerializedString("SendMessage", Map.of("raw", this.rawMessage));
    }

    @Override
    public Action clone() {
        return new SendMessage(this.rawMessage, this.getDelay(), this.getMode(), this.getConditions(), this.getCooldown());
    }

    @Generated
    public String getRawMessage() {
        return this.rawMessage;
    }

    @Generated
    public void setRawMessage(String rawMessage) {
        this.rawMessage = rawMessage;
    }

    public class SendMessageCustomizer
    implements Menu {
        private final SendMessage action;

        public SendMessageCustomizer(SendMessage action) {
            this.action = action;
        }

        public String getName() {
            return "SEND_MESSAGE_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            return MenuUtils.actionBase(this.action, player).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_HANGING_SIGN).setDisplay((Object)Msg.format((String)(SendMessage.this.getRawMessage().isEmpty() ? "<dark_gray><i>" + Msg.translatedString(player.locale(), "customnpcs.messages.empty_string", new Object[0]) : SendMessage.this.getRawMessage())).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                CustomNPCs plugin = CustomNPCs.getInstance();
                Player p = (Player)event.getWhoClicked();
                p.closeInventory();
                plugin.wait(p, WaitingType.MESSAGE);
                new MessageRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }))).build();
        }
    }
}

