/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.api;

import com.google.common.base.Preconditions;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.LegacyAction;
import dev.foxikle.customnpcs.api.NPCApi;
import dev.foxikle.customnpcs.api.events.NpcDeleteEvent;
import dev.foxikle.customnpcs.data.Equipment;
import dev.foxikle.customnpcs.data.Settings;
import dev.foxikle.customnpcs.internal.LookAtAnchor;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class NPC {
    private final InternalNpc npc;

    public NPC(@NotNull World world) {
        if (NPCApi.plugin == null) {
            throw new IllegalStateException("The CustomNPCs plugin does not exist!");
        }
        if (world == null) {
            throw new NullPointerException("world cannot be null.");
        }
        UUID uuid = UUID.randomUUID();
        Settings settings = new Settings();
        settings.setResilient(false);
        this.npc = NPCApi.plugin.createNPC(world, new Location(world, 0.0, 0.0, 0.0), new Equipment(), settings, uuid, null, new ArrayList<Action>());
    }

    @ApiStatus.Internal
    public NPC(InternalNpc npc) {
        if (npc == null) {
            throw new IllegalArgumentException("npc cannot be null.");
        }
        this.npc = npc;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.8")
    public NPC setPostion(@NotNull Location loc) {
        return this.setPosition(loc);
    }

    public NPC setPosition(@NotNull Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc cannot be null.");
        this.npc.setSpawnLoc(loc);
        this.npc.getSettings().setDirection(loc.getYaw());
        return this;
    }

    public NPC setSkin(@NotNull String skinName, @NotNull String signature, @NotNull String value) {
        Preconditions.checkArgument((signature != null ? 1 : 0) != 0, (Object)"signature cannot be null.");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null.");
        Preconditions.checkArgument((skinName != null && !skinName.isEmpty() ? 1 : 0) != 0, (Object)"skinName cannot be null or empty");
        this.npc.getSettings().setSkinData(signature, value, skinName);
        this.npc.updateSkin();
        return this;
    }

    public NPC setActions(Collection<Action> actionImpls) {
        this.npc.setActions(List.copyOf(actionImpls));
        return this;
    }

    public NPC addAction(@NotNull Action action) {
        this.npc.addAction(action);
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.8")
    public NPC setLegacyActions(Collection<LegacyAction> actionImpls) {
        ArrayList<Action> actionList = new ArrayList<Action>();
        for (LegacyAction legacyAction : actionImpls) {
            actionList.add(legacyAction.toAction());
        }
        this.npc.setActions(actionList);
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public void moveTo(@NotNull Location location) {
        this.teleport(location);
    }

    public void teleport(@NotNull Location location) {
        this.npc.teleport(location);
    }

    public void moveTo(Vector vec) {
        this.npc.moveTo(vec);
    }

    public void swingArm() {
        this.npc.swingArm();
    }

    public void injectPlayer(Player player) {
        this.npc.injectPlayer(player);
    }

    public void lookAt(@NotNull Entity e, boolean atHead) {
        Objects.requireNonNull(e);
        this.npc.lookAt(atHead ? LookAtAnchor.HEAD : LookAtAnchor.FEET, e);
    }

    public void lookAt(@NotNull Location location) {
        Objects.requireNonNull(location);
        this.npc.lookAt(location);
    }

    public UUID create() {
        this.npc.createNPC();
        return this.npc.getUniqueID();
    }

    public boolean delete() {
        if (!this.npc.getSettings().isResilient()) {
            throw new IllegalStateException("The NPC must be resilient to be deleted!");
        }
        NpcDeleteEvent event = new NpcDeleteEvent(null, this.npc, NpcDeleteEvent.DeletionSource.API);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.npc.delete();
        return true;
    }

    public void remove() {
        this.npc.remove();
    }

    public void setFacing(@Range(from=-180L, to=180L) float yaw, @Range(from=-90L, to=90L) float pitch) {
        Location loc = this.npc.getSpawnLoc();
        loc.setYaw(yaw);
        loc.setPitch(pitch);
        this.npc.setSpawnLoc(loc);
    }

    public Settings getSettings() {
        return this.npc.getSettings();
    }

    public void setSettings(Settings settings) {
        this.npc.setSettings(settings);
    }

    public Equipment getEquipment() {
        return this.npc.getEquipment();
    }

    public void setEquipment(Equipment equipment) {
        this.npc.setEquipment(equipment);
    }

    public Location getSpawnLocation() {
        return this.npc.getSpawnLoc();
    }

    public Location getLocation() {
        return this.npc.getCurrentLocation();
    }

    public void reloadSettings() {
        this.npc.reloadSettings();
    }
}

