/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.data;

import com.destroystokyo.paper.profile.ProfileProperty;
import dev.foxikle.customnpcs.api.Pose;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public class Settings {
    boolean interactable = false;
    boolean tunnelvision = false;
    boolean resilient = true;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.8")
    double direction = 180.0;
    int interpolationDuration = CustomNPCs.INTERPOLATION_DURATION;
    String value = "";
    String signature = "";
    String[] holograms = new String[]{"An Unnamed NPC"};
    String skinName = "not set";
    boolean hideClickableHologram = false;
    String customInteractableHologram = "";
    Pose pose = Pose.STANDING;
    Color hologramBackground = null;
    boolean hideBackgroundHologram = false;
    boolean upsideDown = false;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Settings(boolean interactable, boolean tunnelvision, boolean resilient, double direction, String value, String signature, String skinName, String name, String customInteractableHologram, boolean hideClickableHologram) {
        this.interactable = interactable;
        this.tunnelvision = tunnelvision;
        this.resilient = resilient;
        this.direction = direction;
        this.value = value;
        this.signature = signature;
        this.skinName = skinName;
        this.holograms = new String[]{name};
        this.hideClickableHologram = hideClickableHologram;
        this.customInteractableHologram = customInteractableHologram;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Settings(boolean interactable, boolean tunnelvision, boolean resilient, double direction, String value, String signature, String skinName, String name, String customInteractableHologram, boolean hideClickableHologram, int interpolationDuration) {
        this.interactable = interactable;
        this.tunnelvision = tunnelvision;
        this.resilient = resilient;
        this.direction = direction;
        this.value = value;
        this.signature = signature;
        this.skinName = skinName;
        this.holograms = new String[]{name};
        this.hideClickableHologram = hideClickableHologram;
        this.customInteractableHologram = customInteractableHologram;
        this.interpolationDuration = interpolationDuration;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Settings(boolean interactable, boolean tunnelvision, boolean resilient, double direction, String value, String signature, String skinName, String[] holograms, String customInteractableHologram, boolean hideClickableHologram, Pose pose) {
        this.interactable = interactable;
        this.tunnelvision = tunnelvision;
        this.resilient = resilient;
        this.direction = direction;
        this.value = value;
        this.signature = signature;
        this.skinName = skinName;
        this.holograms = holograms;
        this.hideClickableHologram = hideClickableHologram;
        this.customInteractableHologram = customInteractableHologram;
        this.pose = pose;
    }

    public Settings(boolean interactable, boolean tunnelvision, boolean resilient, double direction, String value, String signature, String skinName, String[] holograms, String customInteractableHologram, boolean hideClickableHologram, Pose pose, boolean upsideDown) {
        this.interactable = interactable;
        this.tunnelvision = tunnelvision;
        this.resilient = resilient;
        this.direction = direction;
        this.value = value;
        this.signature = signature;
        this.skinName = skinName;
        this.holograms = holograms;
        this.hideClickableHologram = hideClickableHologram;
        this.customInteractableHologram = customInteractableHologram;
        this.pose = pose;
        this.upsideDown = upsideDown;
    }

    public Settings(boolean interactable, boolean tunnelvision, boolean resilient, double direction, String value, String signature, String skinName, String[] holograms, String customInteractableHologram, boolean hideClickableHologram, int interpolationDuration) {
        this.interactable = interactable;
        this.tunnelvision = tunnelvision;
        this.resilient = resilient;
        this.direction = direction;
        this.value = value;
        this.signature = signature;
        this.skinName = skinName;
        this.holograms = holograms;
        this.hideClickableHologram = hideClickableHologram;
        this.customInteractableHologram = customInteractableHologram;
        this.interpolationDuration = interpolationDuration;
    }

    public Settings() {
    }

    public Settings setInteractable(boolean interactable) {
        this.interactable = interactable;
        return this;
    }

    public Settings setTunnelvision(boolean tunnelvision) {
        this.tunnelvision = tunnelvision;
        return this;
    }

    public Settings setResilient(boolean resilient) {
        this.resilient = resilient;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.8")
    public Settings setDirection(double direction) {
        this.direction = direction;
        return this;
    }

    public Settings setInterpolationDuration(int duration) {
        this.interpolationDuration = duration;
        return this;
    }

    public Settings setHideClickableHologram(boolean hideClickableHologram) {
        this.hideClickableHologram = hideClickableHologram;
        return this;
    }

    public Settings setCustomInteractableHologram(String customHologram) {
        this.customInteractableHologram = customHologram;
        return this;
    }

    public Settings setCustomInteractableHologram(Component customHologram) {
        this.customInteractableHologram = (String)MiniMessage.miniMessage().serialize(customHologram);
        return this;
    }

    public Settings setPose(Pose pose) {
        this.pose = pose;
        return this;
    }

    @ApiStatus.Experimental
    public Settings setHologramBackground(Color color) {
        this.hologramBackground = color;
        return this;
    }

    @ApiStatus.Experimental
    public Settings setHideBackgroundHologram(boolean hideBackgroundHologram) {
        this.hideBackgroundHologram = hideBackgroundHologram;
        return this;
    }

    public Settings setUpsideDown(boolean upsideDown) {
        this.upsideDown = upsideDown;
        return this;
    }

    public Component[] getHolograms() {
        Component[] components = new Component[this.holograms.length];
        for (int i = 0; i < this.holograms.length; ++i) {
            components[i] = MiniMessage.miniMessage().deserialize((Object)this.holograms[i]);
        }
        return components;
    }

    public Settings setHolograms(Component ... holograms) {
        this.holograms = new String[holograms.length];
        for (int i = 0; i < holograms.length; ++i) {
            this.holograms[i] = (String)MiniMessage.miniMessage().serialize(holograms[i]);
        }
        return this;
    }

    public String[] getRawHolograms() {
        return this.holograms;
    }

    public Settings setRawHolograms(String ... holograms) {
        this.holograms = holograms;
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public String getName() {
        if (this.holograms.length > 0) {
            return this.holograms[0];
        }
        return "";
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Settings setName(Component name) {
        String serialized = (String)MiniMessage.miniMessage().serialize(name);
        if (this.holograms.length > 0) {
            this.holograms[0] = serialized;
            return this;
        }
        this.holograms = new String[]{serialized};
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public Settings setName(String name) {
        if (this.holograms.length > 0) {
            this.holograms[0] = name;
            return this;
        }
        this.holograms = new String[]{name};
        return this;
    }

    public Settings setSkinData(String signature, String value, String skinName) {
        this.signature = signature;
        this.value = value;
        this.skinName = skinName;
        return this;
    }

    public Settings setSkin(Player player) {
        String signature = null;
        String value = null;
        for (ProfileProperty property : player.getPlayerProfile().getProperties()) {
            if (!property.getName().equals("textures")) continue;
            signature = property.getSignature();
            value = property.getValue();
        }
        if (signature == null || value == null) {
            throw new IllegalStateException("Player does not have a valid skin!");
        }
        this.signature = signature;
        this.value = value;
        this.skinName = player.getName() + "'s skin";
        return this;
    }

    public Settings clone() {
        return new Settings(this.interactable, this.tunnelvision, this.resilient, this.direction, this.value, this.signature, this.skinName, this.holograms, this.customInteractableHologram, this.hideClickableHologram, this.pose);
    }

    @Generated
    public Settings(boolean interactable, boolean tunnelvision, boolean resilient, double direction, int interpolationDuration, String value, String signature, String[] holograms, String skinName, boolean hideClickableHologram, String customInteractableHologram, Pose pose, Color hologramBackground, boolean hideBackgroundHologram, boolean upsideDown) {
        this.interactable = interactable;
        this.tunnelvision = tunnelvision;
        this.resilient = resilient;
        this.direction = direction;
        this.interpolationDuration = interpolationDuration;
        this.value = value;
        this.signature = signature;
        this.holograms = holograms;
        this.skinName = skinName;
        this.hideClickableHologram = hideClickableHologram;
        this.customInteractableHologram = customInteractableHologram;
        this.pose = pose;
        this.hologramBackground = hologramBackground;
        this.hideBackgroundHologram = hideBackgroundHologram;
        this.upsideDown = upsideDown;
    }

    @Generated
    public boolean isInteractable() {
        return this.interactable;
    }

    @Generated
    public boolean isTunnelvision() {
        return this.tunnelvision;
    }

    @Generated
    public boolean isResilient() {
        return this.resilient;
    }

    @Deprecated
    @Generated
    public double getDirection() {
        return this.direction;
    }

    @Generated
    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public String getSkinName() {
        return this.skinName;
    }

    @Generated
    public boolean isHideClickableHologram() {
        return this.hideClickableHologram;
    }

    @Generated
    public String getCustomInteractableHologram() {
        return this.customInteractableHologram;
    }

    @Generated
    public Pose getPose() {
        return this.pose;
    }

    @Generated
    public Color getHologramBackground() {
        return this.hologramBackground;
    }

    @Generated
    public boolean isHideBackgroundHologram() {
        return this.hideBackgroundHologram;
    }

    @Generated
    public boolean isUpsideDown() {
        return this.upsideDown;
    }
}

