/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.LegacyAction;
import dev.foxikle.customnpcs.actions.conditions.ActionAdapter;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.actions.conditions.ConditionalTypeAdapter;
import dev.foxikle.customnpcs.actions.defaultImpl.ActionBar;
import dev.foxikle.customnpcs.actions.defaultImpl.DisplayTitle;
import dev.foxikle.customnpcs.actions.defaultImpl.GiveEffect;
import dev.foxikle.customnpcs.actions.defaultImpl.GiveXP;
import dev.foxikle.customnpcs.actions.defaultImpl.PlaySound;
import dev.foxikle.customnpcs.actions.defaultImpl.RemoveEffect;
import dev.foxikle.customnpcs.actions.defaultImpl.RemoveXP;
import dev.foxikle.customnpcs.actions.defaultImpl.RunCommand;
import dev.foxikle.customnpcs.actions.defaultImpl.SendMessage;
import dev.foxikle.customnpcs.actions.defaultImpl.SendServer;
import dev.foxikle.customnpcs.actions.defaultImpl.Teleport;
import dev.foxikle.customnpcs.data.Equipment;
import dev.foxikle.customnpcs.data.Settings;
import dev.foxikle.customnpcs.internal.FileManager;
import dev.foxikle.customnpcs.internal.commands.NpcCommand;
import dev.foxikle.customnpcs.internal.commands.suggestion.NpcSuggester;
import dev.foxikle.customnpcs.internal.commands.suggestion.SoundSuggester;
import dev.foxikle.customnpcs.internal.commands.suggestion.WorldSuggester;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.listeners.Listeners;
import dev.foxikle.customnpcs.internal.menu.ActionCustomizerMenu;
import dev.foxikle.customnpcs.internal.menu.ActionMenu;
import dev.foxikle.customnpcs.internal.menu.ConditionCustomizerMenu;
import dev.foxikle.customnpcs.internal.menu.ConditionMenu;
import dev.foxikle.customnpcs.internal.menu.DeleteLineMenu;
import dev.foxikle.customnpcs.internal.menu.DeleteMenu;
import dev.foxikle.customnpcs.internal.menu.EquipmentMenu;
import dev.foxikle.customnpcs.internal.menu.ExtraSettingsMenu;
import dev.foxikle.customnpcs.internal.menu.HologramMenu;
import dev.foxikle.customnpcs.internal.menu.MainNPCMenu;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.menu.NewActionMenu;
import dev.foxikle.customnpcs.internal.menu.NewConditionMenu;
import dev.foxikle.customnpcs.internal.menu.PoseEditorMenu;
import dev.foxikle.customnpcs.internal.menu.SkinCatalog;
import dev.foxikle.customnpcs.internal.menu.SkinMenu;
import dev.foxikle.customnpcs.internal.translations.Translations;
import dev.foxikle.customnpcs.internal.utils.ActionRegistry;
import dev.foxikle.customnpcs.internal.utils.AutoUpdater;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import dev.velix.imperat.BukkitConfigBuilder;
import dev.velix.imperat.BukkitImperat;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.Imperat;
import dev.velix.imperat.resolvers.SuggestionResolver;
import io.github.mqzen.menus.Lotus;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.base.pagination.Pagination;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.annotation.Nullable;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.AdvancedPie;
import org.bstats.charts.CustomChart;
import org.bstats.charts.SimplePie;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomNPCs
extends JavaPlugin
implements PluginMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomNPCs.class);
    public static final ActionRegistry ACTION_REGISTRY = new ActionRegistry();
    public static int INTERPOLATION_DURATION;
    private static CustomNPCs instance;
    private static Gson gson;
    private final Cache<UUID, InternalNpc> editingNPCs = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private final Cache<UUID, Boolean> deltionReason = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final String[] COMPATIBLE_VERSIONS = new String[]{"1.20", "1.20.1", "1.20.2", "1.20.3", "1.20.4", "1.20.5", "1.20.6", "1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10"};
    private final String NPC_CLASS = "dev.foxikle.customnpcs.versions.NPC_%s";
    public Map<UUID, WaitingType> waiting = new ConcurrentHashMap<UUID, WaitingType>();
    public List<List<TextDisplay>> holograms = new ArrayList<List<TextDisplay>>();
    public Map<UUID, InternalNpc> npcs = new HashMap<UUID, InternalNpc>();
    public Map<UUID, Action> editingActions = new HashMap<UUID, Action>();
    public Map<UUID, Action> originalEditingActions = new HashMap<UUID, Action>();
    public Map<UUID, Condition> editingConditionals = new HashMap<UUID, Condition>();
    public Map<UUID, Condition> originalEditingConditionals = new HashMap<UUID, Condition>();
    public boolean papi = false;
    public boolean update;
    public String serverVersion;
    public MiniMessage miniMessage = MiniMessage.miniMessage();
    Listeners listeners;
    private FileManager fileManager;
    private MenuUtils mu;
    private AutoUpdater updater;
    private Lotus lotus;
    private Imperat<BukkitSource> imperat;
    private boolean reloading = false;
    private boolean debug = false;

    public void onEnable() {
        System.setProperty("org.bukkit.plugin.java.LibraryLoader.centralURL", "https://repo1.maven.org/maven2");
        instance = this;
        if (!this.checkForValidVersion()) {
            this.printInvalidVersion();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        String s = this.translateVersion();
        try {
            this.getLogger().info("Loading class: " + String.format("dev.foxikle.customnpcs.versions.NPC_%s", s));
            this.getClassLoader().loadClass(String.format("dev.foxikle.customnpcs.versions.NPC_%s", s));
        }
        catch (ClassNotFoundException e) {
            this.getLogger().log(Level.SEVERE, "Failed to load NPC class for server version " + s + "!", e);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "SERVERE ERROR: ", e);
        }
        INTERPOLATION_DURATION = this.getConfig().getInt("DefaultInterpolationDuration");
        new Translations().setup();
        gson = new GsonBuilder().registerTypeAdapter(Condition.class, (Object)new ConditionalTypeAdapter()).registerTypeAdapter(LegacyAction.class, (Object)new ActionAdapter()).create();
        this.fileManager = new FileManager(this);
        this.mu = new MenuUtils(this);
        this.updater = new AutoUpdater(this);
        this.update = this.updater.checkForUpdates();
        if (!this.fileManager.createFiles()) {
            throw new RuntimeException("Failed to create files");
        }
        this.getLogger().info("Loading action registry...");
        ACTION_REGISTRY.register("ActionBar", ActionBar.class, ActionBar::creationButton);
        ACTION_REGISTRY.register("DisplayTitle", DisplayTitle.class, DisplayTitle::creationButton);
        ACTION_REGISTRY.register("GiveEffect", GiveEffect.class, GiveEffect::creationButton);
        ACTION_REGISTRY.register("GiveXP", GiveXP.class, GiveXP::creationButton);
        ACTION_REGISTRY.register("PlaySound", PlaySound.class, PlaySound::creationButton);
        ACTION_REGISTRY.register("RemoveEffect", RemoveEffect.class, RemoveEffect::creationButton);
        ACTION_REGISTRY.register("RemoveXP", RemoveXP.class, RemoveXP::creationButton);
        ACTION_REGISTRY.register("RunCommand", RunCommand.class, RunCommand::creationButton);
        ACTION_REGISTRY.register("SendMessage", SendMessage.class, SendMessage::creationButton);
        ACTION_REGISTRY.register("SendServer", SendServer.class, SendServer::creationButton, true, false, true);
        ACTION_REGISTRY.register("Teleport", Teleport.class, Teleport::creationButton);
        try {
            this.getLogger().info("Loading NPCs!");
            for (UUID uuid : this.fileManager.getValidNPCs()) {
                this.fileManager.loadNPC(uuid);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load NPC:", e);
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            this.getMenuUtils().getSkinCatalogue(Locale.ENGLISH);
            this.getMenuUtils().getSkinCatalogue(Locale.GERMAN);
            this.getMenuUtils().getSkinCatalogue(Locale.SIMPLIFIED_CHINESE);
            this.getMenuUtils().getSkinCatalogue(new Locale("ru"));
        }, 20L);
        Metrics metrics = new Metrics((Plugin)this, 18898);
        metrics.addCustomChart((CustomChart)new SimplePie("use_papi", () -> String.valueOf(this.papi)));
        metrics.addCustomChart((CustomChart)new SimplePie("look_interval", () -> String.valueOf(this.getConfig().getInt("LookInterval"))));
        metrics.addCustomChart((CustomChart)new SimplePie("injection_interval", () -> String.valueOf(this.getConfig().getInt("InjectionInterval"))));
        metrics.addCustomChart((CustomChart)new SimplePie("injection_distance", () -> String.valueOf(this.getConfig().getInt("InjectionDistance"))));
        metrics.addCustomChart((CustomChart)new SimplePie("hologram_interval", () -> String.valueOf(this.getConfig().getInt("HologramUpdateInterval"))));
        metrics.addCustomChart((CustomChart)new SimplePie("update_alerts", () -> String.valueOf(this.getConfig().getBoolean("AlertOnUpdate"))));
        metrics.addCustomChart((CustomChart)new SimplePie("npc_count", () -> String.valueOf(this.npcs.size())));
        metrics.addCustomChart((CustomChart)new AdvancedPie("total_actions", () -> {
            int actionbar = 0;
            int title = 0;
            int message = 0;
            int give_effect = 0;
            int remove_effect = 0;
            int give_xp = 0;
            int remove_xp = 0;
            int play_sound = 0;
            int teleport = 0;
            int send_server = 0;
            int run_command = 0;
            for (InternalNpc npc : this.npcs.values()) {
                for (Action action : npc.getActions()) {
                    if (action instanceof ActionBar) {
                        ++actionbar;
                        continue;
                    }
                    if (action instanceof DisplayTitle) {
                        ++title;
                        continue;
                    }
                    if (action instanceof SendMessage) {
                        ++message;
                        continue;
                    }
                    if (action instanceof GiveEffect) {
                        ++give_effect;
                        continue;
                    }
                    if (action instanceof RemoveEffect) {
                        ++remove_effect;
                        continue;
                    }
                    if (action instanceof GiveXP) {
                        ++give_xp;
                        continue;
                    }
                    if (action instanceof RemoveXP) {
                        ++remove_xp;
                        continue;
                    }
                    if (action instanceof PlaySound) {
                        ++play_sound;
                        continue;
                    }
                    if (action instanceof Teleport) {
                        ++teleport;
                        continue;
                    }
                    if (action instanceof SendServer) {
                        ++send_server;
                        continue;
                    }
                    if (!(action instanceof RunCommand)) continue;
                    ++run_command;
                }
            }
            return Map.ofEntries(Map.entry("ActionBar", actionbar), Map.entry("DisplayTitle", title), Map.entry("SendMessage", message), Map.entry("GiveEffect", give_effect), Map.entry("RemoveEffect", remove_effect), Map.entry("GiveXP", give_xp), Map.entry("RemoveXP", remove_xp), Map.entry("PlaySound", play_sound), Map.entry("Teleport", teleport), Map.entry("SendServer", send_server), Map.entry("RunCommand", run_command));
        }));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("Successfully hooked into PlaceholderAPI.");
            this.papi = true;
        } else {
            this.papi = false;
            this.getLogger().warning("Could not find PlaceholderAPI! PlaceholderAPI isn't required, but CustomNPCs does support it.");
        }
        if (!System.getProperties().containsKey("customnpcs-reload-check")) {
            this.getLogger().info("Loading listeners...");
            this.listeners = new Listeners(this);
            this.getServer().getPluginManager().registerEvents((Listener)this.listeners, (Plugin)this);
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this);
        }
        this.listeners.start();
        this.getLogger().info("Loading menus!");
        this.lotus = Lotus.load((Plugin)this);
        this.lotus.registerMenu((Menu)new ActionMenu());
        this.lotus.registerMenu((Menu)new ActionCustomizerMenu());
        this.lotus.registerMenu((Menu)new MainNPCMenu());
        this.lotus.registerMenu((Menu)new ConditionCustomizerMenu());
        this.lotus.registerMenu((Menu)new ConditionMenu());
        this.lotus.registerMenu((Menu)new DeleteMenu());
        this.lotus.registerMenu((Menu)new EquipmentMenu());
        this.lotus.registerMenu((Menu)new ExtraSettingsMenu());
        this.lotus.registerMenu((Menu)new NewActionMenu());
        this.lotus.registerMenu((Menu)new NewConditionMenu());
        this.lotus.registerMenu((Menu)new SkinCatalog());
        this.lotus.registerMenu((Menu)new SkinMenu());
        this.lotus.registerMenu((Menu)new HologramMenu());
        this.lotus.registerMenu((Menu)new DeleteLineMenu());
        this.lotus.registerMenu((Menu)new PoseEditorMenu());
        if (!System.getProperties().containsKey("CUSTOMNPCS_LOADED")) {
            this.getLogger().info("Loading commands!");
            this.imperat = ((BukkitConfigBuilder)((BukkitConfigBuilder)((BukkitConfigBuilder)((BukkitConfigBuilder)BukkitImperat.builder((Plugin)this).applyBrigadier(false).namedSuggestionResolver("sound", (SuggestionResolver)new SoundSuggester())).namedSuggestionResolver("current_npc", (SuggestionResolver)new NpcSuggester())).namedSuggestionResolver("broken_npc", (SuggestionResolver)new NpcSuggester())).namedSuggestionResolver("worlds", (SuggestionResolver)new WorldSuggester())).build();
            this.imperat.registerCommand((Object)new NpcCommand());
        }
        System.setProperty("CUSTOMNPCS_LOADED", "true");
    }

    public boolean checkForValidVersion() {
        this.serverVersion = Bukkit.getMinecraftVersion();
        return List.of(this.COMPATIBLE_VERSIONS).contains(this.serverVersion);
    }

    public void onDisable() {
        for (List<TextDisplay> t : this.holograms) {
            if (t == null) continue;
            t.forEach(Entity::remove);
        }
        if (this.listeners != null) {
            this.listeners.stop();
        }
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        for (InternalNpc npc : this.npcs.values()) {
            npc.remove();
        }
        this.holograms.clear();
        this.npcs.clear();
        if (!this.reloading && this.imperat != null) {
            this.imperat.shutdownPlatform();
            this.imperat.unregisterAllCommands();
        }
    }

    public List<InternalNpc> getNPCs() {
        return this.npcs.values().stream().toList();
    }

    public void addNPC(InternalNpc npc, List<TextDisplay> hologram) {
        this.holograms.add(hologram);
        this.npcs.put(npc.getUniqueID(), npc);
    }

    public InternalNpc getNPCByID(UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid cannot be null");
        }
        if (!this.npcs.containsKey(uuid)) {
            return null;
        }
        return this.npcs.get(uuid);
    }

    public MenuUtils getMenuUtils() {
        return this.mu;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
    }

    public InternalNpc createNPC(World world, Location location, Equipment equipment, Settings settings, UUID uuid, @Nullable Player target, List<Action> actionImpls) {
        try {
            Class<?> clazz = Class.forName(String.format("dev.foxikle.customnpcs.versions.NPC_%s", this.translateVersion()));
            return (InternalNpc)clazz.getConstructor(((Object)((Object)this)).getClass(), World.class, Location.class, Equipment.class, Settings.class, UUID.class, Player.class, List.class).newInstance(new Object[]{this, world, location, equipment, settings, uuid, target, actionImpls});
        }
        catch (ReflectiveOperationException e) {
            this.getLogger().log(Level.SEVERE, "An error occurred whilst creating the NPC '{name}! This is most likely a configuration issue.".replace("{name}", settings.getName()), e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "An error occurred whilst creating the NPC '{name}!".replace("{name}", settings.getName()), e);
            throw new RuntimeException(e);
        }
    }

    public String translateVersion() {
        return switch (this.serverVersion) {
            case "1.20", "1.20.1" -> "v1_20_R1";
            case "1.20.2" -> "v1_20_R2";
            case "1.20.3", "1.20.4" -> "v1_20_R3";
            case "1.20.5", "1.20.6" -> "v1_20_R4";
            case "1.21", "1.21.1" -> "v1_21_R0";
            case "1.21.2", "1.21.3" -> "v1_21_R1";
            case "1.21.4" -> "v1_21_R2";
            case "1.21.5" -> "v1_21_R3";
            case "1.21.6", "1.21.7", "1.21.8" -> "v1_21_R4";
            case "1.21.9", "1.21.10" -> "v1_21_R5";
            default -> "";
        };
    }

    private Locale setupLocale(String lang) {
        return switch (lang.toUpperCase()) {
            case "GERMAN", "DE" -> Locale.GERMAN;
            case "CHINESE", "ZH" -> Locale.CHINESE;
            case "RUSSIAN", "RU" -> new Locale("ru");
            default -> Locale.ENGLISH;
        };
    }

    private void printInvalidVersion() {
        java.util.logging.Logger logger = this.getLogger();
        logger.severe("");
        logger.severe("");
        logger.severe("+------------------------------------------------------------------------------+");
        logger.severe("|                      INVALID SERVER VERSION DETECTED                         |");
        logger.severe("|             ** PLEASE USE ONE OF THE FOLLOWING SERVER VERSIONS **            |");
        logger.severe("|                                [1.20.x, 1.21.x]                              |");
        logger.severe("|                               DETECTED: '" + this.serverVersion + "'                             |");
        logger.severe("|           Please contact @foxikle on Discord for more information.           |");
        logger.severe("+------------------------------------------------------------------------------+");
        logger.severe("");
        logger.severe("");
    }

    public boolean isWaiting(Player player, WaitingType type) {
        return this.waiting.getOrDefault(player.getUniqueId(), null) == type;
    }

    public void wait(Player player, WaitingType type) {
        this.waiting.put(player.getUniqueId(), type);
    }

    public Pagination getSkinCatalog(Player player) {
        return this.getMenuUtils().getSkinCatalogue(player.locale());
    }

    @Generated
    public static CustomNPCs getInstance() {
        return instance;
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }

    @Generated
    public Cache<UUID, InternalNpc> getEditingNPCs() {
        return this.editingNPCs;
    }

    @Generated
    public Cache<UUID, Boolean> getDeltionReason() {
        return this.deltionReason;
    }

    @Generated
    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    @Generated
    public FileManager getFileManager() {
        return this.fileManager;
    }

    @Generated
    public AutoUpdater getUpdater() {
        return this.updater;
    }

    @Generated
    public Lotus getLotus() {
        return this.lotus;
    }

    @Generated
    public Imperat<BukkitSource> getImperat() {
        return this.imperat;
    }

    @Generated
    public boolean isReloading() {
        return this.reloading;
    }

    @Generated
    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

