/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal;

import dev.foxikle.customnpcs.api.events.NpcInjectEvent;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class InjectionManager {
    private final CustomNPCs plugin;
    private final InternalNpc npc;
    private final int INJECTION_DISTANCE;
    ConcurrentHashMap<UUID, Boolean> isVisible = new ConcurrentHashMap();
    private int task;

    public InjectionManager(CustomNPCs plugin, InternalNpc npc) {
        this.plugin = plugin;
        this.npc = npc;
        this.INJECTION_DISTANCE = (int)Math.pow(plugin.getConfig().getInt("InjectionDistance"), 2.0);
    }

    public void setup() {
        if (this.task != -1) {
            this.shutDown();
        }
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkForInjections, 0L, (long)this.plugin.getConfig().getInt("InjectionInterval")).getTaskId();
    }

    private void checkForInjections() {
        ArrayList toRemove = new ArrayList(this.isVisible.keySet());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.isVisible.containsKey(player.getUniqueId())) {
                toRemove.remove(player.getUniqueId());
            }
            if (player.getWorld() != this.npc.getCurrentLocation().getWorld()) {
                if (this.plugin.isDebug()) {
                    this.plugin.getLogger().info(String.format("[DEBUG] Removing %s from %s's injection handler as they are in a different world.", player.getName(), this.npc.getSettings().getName()));
                }
                this.isVisible.remove(player.getUniqueId());
                continue;
            }
            double distance = player.getLocation().distanceSquared(this.npc.getCurrentLocation());
            if (distance > (double)this.INJECTION_DISTANCE) {
                if (this.plugin.isDebug()) {
                    this.plugin.getLogger().info(String.format("[DEBUG] Tried to inject %s with %s, but they are too far away! (Distance^2: %f )", player.getName(), this.npc.getSettings().getName(), distance));
                }
                this.isVisible.put(player.getUniqueId(), false);
                continue;
            }
            if (!(distance <= (double)this.INJECTION_DISTANCE) || this.isVisible.getOrDefault(player.getUniqueId(), false).booleanValue()) continue;
            NpcInjectEvent injectEvent = new NpcInjectEvent(player, this.npc, distance);
            Bukkit.getServer().getPluginManager().callEvent((Event)injectEvent);
            if (injectEvent.isCancelled()) continue;
            this.npc.injectPlayer(player);
            this.isVisible.put(player.getUniqueId(), true);
        }
        for (UUID uuid : toRemove) {
            if (this.plugin.isDebug()) {
                this.plugin.getLogger().info(String.format("[DEBUG] Removing %s from %s's injection handler! (likley offline)", uuid.toString(), this.npc.getSettings().getName()));
            }
            this.isVisible.remove(uuid);
        }
    }

    public void shutDown() {
        Bukkit.getScheduler().cancelTask(this.task);
        this.task = -1;
    }
}

