/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.commands;

import com.google.common.collect.Iterables;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.velix.imperat.BukkitSource;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class CommandUtils {
    @NotNull
    public static Component getHelpComponent(Locale p) {
        Component component = Msg.translate(p, "customnpcs.commands.header", Component.text((String)CustomNPCs.getInstance().getPluginMeta().getVersion()));
        component = component.appendNewline().append(Msg.translate(p, "customnpcs.commands.help.help.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.help.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.help.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.help.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.manage.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.manage.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.manage.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.manage.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.create.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.create.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.create.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.create.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.delete.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.delete.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.delete.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.delete.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.edit.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.edit.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.edit.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.edit.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.movehere.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.movehere.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.movehere.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.movehere.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.clone.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.clone.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.clone.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.clone.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.reload.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.reload.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.reload.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.reload.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.goto.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.goto.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.goto.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.goto.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.wiki.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.wiki.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.wiki.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.wiki.hover", new Object[0])))).appendNewline().append(Msg.translate(p, "customnpcs.commands.help.debug.syntax", new Object[0]).color((TextColor)NamedTextColor.GOLD).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.debug.aliases", new Object[0])))).append(Msg.translate(p, "customnpcs.commands.help.debug.description", new Object[0]).color((TextColor)NamedTextColor.DARK_AQUA).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.help.debug.hover", new Object[0])))).appendNewline().append((Component)Component.text((String)"                                                                                 ", (TextColor)NamedTextColor.DARK_GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH}));
        return component;
    }

    @NotNull
    public static Component getListComponent(Locale p) {
        CustomNPCs plugin = CustomNPCs.getInstance();
        if (plugin.getNPCs().isEmpty()) {
            return Msg.translate(p, "customnpcs.commands.manage.no_npcs", new Object[0]);
        }
        Component message = Msg.translate(p, "customnpcs.commands.manage.header", new Object[0]).appendNewline();
        for (InternalNpc npc : plugin.getNPCs()) {
            if (!npc.getSettings().isResilient()) continue;
            Component name = Msg.format("<gray>\u25c6<reset> ").append(plugin.getMiniMessage().deserialize((Object)npc.getSettings().getName()).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.manage.copy_uuid", new Object[0])))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)npc.getUniqueID().toString())).append(Msg.translate(p, "customnpcs.commands.manage.button.edit", new Object[0]).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.manage.button.edit.hover", new Object[0]))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/npc edit " + String.valueOf(npc.getUniqueID()))))).append(Msg.translate(p, "customnpcs.commands.manage.button.delete", new Object[0]).appendSpace().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Msg.translate(p, "customnpcs.commands.manage.button.delete.hover", new Object[0]))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)("/npc delete " + String.valueOf(npc.getUniqueID()))))).appendNewline();
            message = message.append(name);
        }
        message = message.append((Component)Component.text((String)"                                                                                 ", (TextColor)NamedTextColor.DARK_GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH}));
        return message;
    }

    public static boolean checkNpc(BukkitSource source, UUID npc) {
        Locale locale = Locale.getDefault();
        if (!source.isConsole()) {
            locale = source.asPlayer().locale();
        }
        if (npc == null) {
            source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_name_or_uuid", new Object[0]));
            return false;
        }
        boolean valid = CustomNPCs.getInstance().npcs.containsKey(npc);
        if (!valid) {
            source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_uuid", new Object[0]));
        }
        return valid;
    }

    public static UUID parseNpc(BukkitSource source, String data) {
        UUID uuid;
        Locale locale = Locale.getDefault();
        if (!source.isConsole()) {
            locale = source.asPlayer().locale();
        }
        CustomNPCs plugin = CustomNPCs.getInstance();
        try {
            uuid = UUID.fromString(data);
            if (plugin.getNPCByID(uuid) == null) {
                source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_uuid", new Object[0]));
                return null;
            }
        }
        catch (IllegalArgumentException ignored) {
            UUID uuid2;
            if (source.isConsole()) {
                return null;
            }
            Player p = source.asPlayer();
            Locale finalLocale = locale;
            Set uuids = plugin.npcs.values().stream().map(npc -> {
                if (plugin.getMiniMessage().stripTags(npc.getSettings().getName()).equalsIgnoreCase(data)) {
                    return npc.getUniqueID();
                }
                return null;
            }).collect(Collectors.toSet());
            uuids.removeIf(Objects::isNull);
            if (uuids.isEmpty()) {
                source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_name_or_uuid", new Object[0]));
                return null;
            }
            if (uuids.size() > 1) {
                double value = Double.MAX_VALUE;
                uuid2 = null;
                for (UUID id : uuids) {
                    double ds;
                    InternalNpc npc2 = plugin.getNPCByID(id);
                    assert (npc2 != null) : "Npc is null when parsing the closest NPC";
                    if (p.getWorld() != npc2.getWorld() || !((ds = npc2.getCurrentLocation().distanceSquared(p.getLocation())) < value)) continue;
                    uuid2 = id;
                    value = ds;
                }
                if (uuid2 == null) {
                    uuid2 = (UUID)Iterables.getFirst(uuids, null);
                }
            } else {
                uuid2 = (UUID)Iterables.getFirst(uuids, null);
            }
            if (uuid2 == null) {
                source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_name_or_uuid", new Object[0]));
                return null;
            }
            if (plugin.getNPCByID(uuid2) == null) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.commands.invalid_uuid", new Object[0]));
                return null;
            }
            return uuid2;
        }
        InternalNpc npc3 = plugin.getNPCByID(uuid);
        if (npc3 == null) {
            source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_name_or_uuid", new Object[0]));
            return null;
        }
        boolean valid = CustomNPCs.getInstance().npcs.containsKey(uuid);
        if (!valid) {
            source.reply((ComponentLike)Msg.translate(locale, "customnpcs.commands.invalid_uuid", new Object[0]));
            return null;
        }
        return uuid;
    }

    public static Locale getLocale(BukkitSource source) {
        if (source.isConsole()) {
            return Locale.getDefault();
        }
        return source.asPlayer().locale();
    }

    @Generated
    private CommandUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

