/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.commands;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.commands.CommandUtils;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.annotations.Description;
import dev.velix.imperat.annotations.Greedy;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.command.AttachmentMode;
import java.util.UUID;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.entity.Player;

@SubCommand(value={"delete"}, attachment=AttachmentMode.MAIN)
@Permission(value="customnpcs.delete")
@Description(value="Deletes the specified NPC")
public class DeleteCommand {
    @Usage
    public void usage(BukkitSource source, @Named(value="npc") @SuggestionProvider(value="current_npc") @Greedy String npc) {
        if (source.isConsole()) {
            source.reply((ComponentLike)Msg.format("You can't do this :P"));
            return;
        }
        UUID uuid = CommandUtils.parseNpc(source, npc);
        if (uuid == null) {
            return;
        }
        if (!CommandUtils.checkNpc(source, uuid)) {
            return;
        }
        Player p = source.asPlayer();
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc finalNpc = plugin.getNPCByID(uuid);
        assert (finalNpc != null);
        plugin.getEditingNPCs().put((Object)p.getUniqueId(), (Object)finalNpc);
        plugin.getDeltionReason().put((Object)p.getUniqueId(), (Object)false);
        plugin.getLotus().openMenu(p, "npc_delete");
    }
}

