/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.commands;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.commands.CommandUtils;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.annotations.Description;
import dev.velix.imperat.annotations.Greedy;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.command.AttachmentMode;
import java.util.UUID;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Permission(value="customnpcs.edit")
@SubCommand(value={"edit"}, attachment=AttachmentMode.MAIN)
@Description(value="Edits an NPC")
public class EditCommand {
    @Usage
    public void editNpc(BukkitSource source, @Named(value="npc") @SuggestionProvider(value="current_npc") @Greedy String npc) {
        if (source.isConsole()) {
            source.reply((ComponentLike)Msg.format("You can't do this :P"));
            return;
        }
        UUID uuid = CommandUtils.parseNpc(source, npc);
        if (uuid == null) {
            return;
        }
        Player p = source.asPlayer();
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc finalNpc = plugin.getNPCByID(uuid);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            InternalNpc newNpc = plugin.createNPC(p.getWorld(), finalNpc.getSpawnLoc(), finalNpc.getEquipment(), finalNpc.getSettings(), finalNpc.getUniqueID(), null, finalNpc.getActions());
            plugin.getEditingNPCs().put((Object)p.getUniqueId(), (Object)newNpc);
            plugin.getLotus().openMenu(p, "npc_main");
        }, 1L);
    }
}

