/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.commands;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.commands.CommandUtils;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.annotations.Greedy;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.command.AttachmentMode;
import java.util.UUID;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@SubCommand(value={"movehere"}, attachment=AttachmentMode.MAIN)
@Permission(value="customnpcs.commands.movehere")
public class MoveCommand {
    @Usage
    public void usage(BukkitSource source, @Named(value="npc") @SuggestionProvider(value="current_npc") @Greedy String npc) {
        if (source.isConsole()) {
            source.reply((ComponentLike)Msg.format("<red>You can't do this :P"));
            return;
        }
        UUID uuid = CommandUtils.parseNpc(source, npc);
        if (uuid == null) {
            return;
        }
        if (!CommandUtils.checkNpc(source, uuid)) {
            return;
        }
        Player p = source.asPlayer();
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc finalNpc = plugin.getNPCByID(uuid);
        p.sendMessage(Msg.translate(p.locale(), "customnpcs.commands.move.nudge", new Object[0]));
        assert (finalNpc != null);
        finalNpc.teleport(p.getLocation());
        finalNpc.remove();
        finalNpc.createNPC();
        Bukkit.getOnlinePlayers().forEach(finalNpc::injectPlayer);
    }
}

