/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.commands;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.defaultImpl.PlaySound;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import dev.velix.imperat.BukkitSource;
import dev.velix.imperat.annotations.Default;
import dev.velix.imperat.annotations.Description;
import dev.velix.imperat.annotations.Greedy;
import dev.velix.imperat.annotations.Named;
import dev.velix.imperat.annotations.Permission;
import dev.velix.imperat.annotations.SubCommand;
import dev.velix.imperat.annotations.SuggestionProvider;
import dev.velix.imperat.annotations.Usage;
import dev.velix.imperat.command.AttachmentMode;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@SubCommand(value={"setsound"}, attachment=AttachmentMode.MAIN)
@Permission(value="customnpcs.edit")
@Description(value="Sets the sound of the playsound action!")
public class SetsoundCommand {
    @Usage
    public void usage(BukkitSource source, @Default(value="minecraft:ui.button.click") @Named(value="sound") @SuggestionProvider(value="sound") @Greedy String soundRaw) {
        if (source.isConsole()) {
            source.reply("You can't do this :P");
            return;
        }
        Player p = source.asPlayer();
        CustomNPCs plugin = CustomNPCs.getInstance();
        String formatted = soundRaw.trim().toLowerCase();
        if (plugin.isWaiting(p, WaitingType.SOUND)) {
            if (Registry.SOUNDS.get(NamespacedKey.fromString((String)formatted)) == null) {
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.commands.setsound.unknown_sound", new Object[0]));
            }
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                plugin.waiting.remove(p.getUniqueId());
                Action actionImpl = plugin.editingActions.get(p.getUniqueId());
                if (!(actionImpl instanceof PlaySound)) {
                    throw new IllegalArgumentException("Action " + actionImpl.getClass().getName() + " is not of type PlaySound");
                }
                PlaySound action = (PlaySound)actionImpl;
                action.setSound(formatted);
                p.sendMessage(Msg.translate(p.locale(), "customnpcs.commands.setsound.success", Component.text((String)formatted)));
                plugin.getLotus().openMenu(p, actionImpl.getMenu());
            });
        } else {
            p.sendMessage(Msg.translate(p.locale(), "customnpcs.commands.setsound.was_not_waiting", new Object[0]));
        }
    }
}

