/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.base.MenuView;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.button.actions.impl.CloseMenuAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EquipmentMenu
implements Menu {
    public String getName() {
        return "npc_equipment";
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
        return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.equipment.title", new Object[0]));
    }

    public void onPostClick(MenuView<?> playerMenuView, InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory() == event.getWhoClicked().getInventory()) {
            event.setCancelled(false);
        }
    }

    @NotNull
    public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
        return Capacity.ofRows((int)6);
    }

    @NotNull
    public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
        if (npc == null) {
            return Content.builder((Capacity)capacity).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.error.no_npc", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.error.no_npc.lore", new Object[0]))).build(), (ButtonClickAction)new CloseMenuAction())).build();
        }
        return Content.builder((Capacity)capacity).apply(content -> content.fill(MenuItems.MENU_GLASS)).setButton(8, Button.clickable((ItemStack)MenuItems.importArmor(player), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            npc.getEquipment().importFromEntityEquipment(p.getEquipment());
            p.playSound((Entity)p, Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            menuView.replaceButton(13, MenuItems.helmetSlot(npc, player));
            menuView.replaceButton(21, MenuItems.offhandSlot(npc, player));
            menuView.replaceButton(22, MenuItems.chestplateSlot(npc, player));
            menuView.replaceButton(23, MenuItems.handSlot(npc, player));
            menuView.replaceButton(31, MenuItems.leggingsSlot(npc, player));
            menuView.replaceButton(40, MenuItems.bootsSlot(npc, player));
        }))).setButton(13, MenuItems.helmetSlot(npc, player)).setButton(21, MenuItems.offhandSlot(npc, player)).setButton(22, MenuItems.chestplateSlot(npc, player)).setButton(23, MenuItems.handSlot(npc, player)).setButton(31, MenuItems.leggingsSlot(npc, player)).setButton(40, MenuItems.bootsSlot(npc, player)).setButton(49, MenuItems.toMain(player)).build();
    }
}

