/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.button.actions.impl.CloseMenuAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HologramMenu
implements Menu {
    public static final Map<UUID, Integer> editingIndicies = new ConcurrentHashMap<UUID, Integer>();

    public String getName() {
        return "npc_holograms";
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
        return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.holograms.title", new Object[0]));
    }

    @NotNull
    public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
        return Capacity.ofRows((int)6);
    }

    @NotNull
    public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
        if (npc == null) {
            return Content.builder((Capacity)capacity).apply(content -> content.fillBorder(MenuItems.MENU_GLASS)).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.error.no_npc", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.error.no_npc.lore", new Object[0]))).build(), (ButtonClickAction)new CloseMenuAction())).build();
        }
        return Content.builder((Capacity)capacity).apply(content -> content.fillBorder(MenuItems.MENU_GLASS)).apply(content -> content.addButton(MenuItems.currentLines(npc, player).toArray(new Button[0]))).setButton(45, MenuItems.toMain(player)).build();
    }
}

