/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.menu;

import dev.foxikle.customnpcs.api.Pose;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.runnables.NudgeRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.button.actions.impl.CloseMenuAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PoseEditorMenu
implements Menu {
    public static final Map<UUID, InternalNpc> previewNPCs = new HashMap<UUID, InternalNpc>();

    public String getName() {
        return "npc_pose";
    }

    @NotNull
    public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
        return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.pose.title", new Object[0]));
    }

    @NotNull
    public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
        return Capacity.ofRows((int)3);
    }

    @NotNull
    public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
        CustomNPCs plugin = CustomNPCs.getInstance();
        InternalNpc npc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
        if (npc == null) {
            return Content.builder((Capacity)capacity).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_STAINED_GLASS_PANE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.main.error.no_npc", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.main.error.no_npc.lore", new Object[0]))).build(), (ButtonClickAction)new CloseMenuAction())).build();
        }
        Button nudgeButton = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RECOVERY_COMPASS).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.nudge.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.nudge", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            InternalNpc finalClickedNpc = clickedNpc.clone();
            finalClickedNpc.getSettings().setResilient(false);
            Optional.ofNullable(plugin.getNPCByID(clickedNpc.getUniqueID())).ifPresent(internalNpc -> {
                internalNpc.remove();
                finalClickedNpc.createNPC();
                previewNPCs.put(player.getUniqueId(), finalClickedNpc);
            });
            plugin.wait(player, WaitingType.NUDGE);
            new NudgeRunnable(player, plugin).runTaskTimer((Plugin)plugin, 1L, 15L);
            player.closeInventory();
        }));
        Button standing = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ARMOR_STAND).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.standing.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.standing", new Object[0]))).enchant(Enchantment.MENDING, npc.getSettings().getPose() == Pose.STANDING ? 1 : 0)).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (clickedNpc.getSettings().getPose() == Pose.STANDING) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.pose.already", "standing"));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            clickedNpc.getSettings().setPose(Pose.STANDING);
            plugin.getLotus().openMenu((Player)event.getWhoClicked(), "npc_main");
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
        }));
        Button sitting = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_STAIRS).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.sitting.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.sitting", new Object[0]))).enchant(Enchantment.MENDING, npc.getSettings().getPose() == Pose.SITTING ? 1 : 0)).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (clickedNpc.getSettings().getPose() == Pose.SITTING) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.pose.already", "sitting"));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            clickedNpc.getSettings().setPose(Pose.SITTING);
            plugin.getLotus().openMenu((Player)event.getWhoClicked(), "npc_main");
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
        }));
        Button swimming = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.WATER_BUCKET).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.swimming.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.swimming", new Object[0]))).enchant(Enchantment.MENDING, npc.getSettings().getPose() == Pose.SWIMMING ? 1 : 0)).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (clickedNpc.getSettings().getPose() == Pose.SWIMMING) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.pose.already", "swimming"));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            clickedNpc.getSettings().setPose(Pose.SWIMMING);
            plugin.getLotus().openMenu((Player)event.getWhoClicked(), "npc_main");
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
        }));
        Button crouching = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.SMOOTH_QUARTZ_SLAB).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.crouching.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.crouching", new Object[0]))).enchant(Enchantment.MENDING, npc.getSettings().getPose() == Pose.CROUCHING ? 1 : 0)).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (clickedNpc.getSettings().getPose() == Pose.CROUCHING) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.pose.already", "crouching"));
                return;
            }
            clickedNpc.getSettings().setPose(Pose.CROUCHING);
            plugin.getLotus().openMenu((Player)event.getWhoClicked(), "npc_main");
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
        }));
        Button sleeping = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_BED).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.sleeping.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.sleeping", new Object[0]))).enchant(Enchantment.MENDING, npc.getSettings().getPose() == Pose.SLEEPING ? 1 : 0)).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (clickedNpc.getSettings().getPose() == Pose.SLEEPING) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.pose.already", "sleeping"));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            clickedNpc.getSettings().setPose(Pose.SLEEPING);
            plugin.getLotus().openMenu((Player)event.getWhoClicked(), "npc_main");
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
        }));
        Button dying = Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LAVA_BUCKET).setLore((Object[])Msg.lore(player.locale(), "customnpcs.menus.pose.dying.lore", new Object[0]))).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.pose.dying", new Object[0]))).enchant(Enchantment.MENDING, npc.getSettings().getPose() == Pose.DYING ? 1 : 0)).addFlags(ItemFlag.values())).build(), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> {
            InternalNpc clickedNpc = (InternalNpc)plugin.getEditingNPCs().getIfPresent((Object)player.getUniqueId());
            event.setCancelled(true);
            if (clickedNpc == null) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.error.npc-menu-expired ", new Object[0]));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            if (clickedNpc.getSettings().getPose() == Pose.DYING) {
                player.sendMessage(Msg.translate(player.locale(), "customnpcs.pose.already", "dying"));
                player.playSound((Entity)player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            clickedNpc.getSettings().setPose(Pose.DYING);
            plugin.getLotus().openMenu((Player)event.getWhoClicked(), "npc_main");
            player.playSound((Entity)player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
        }));
        return Content.builder((Capacity)capacity).apply(content -> {
            content.fillBorder(MenuItems.MENU_GLASS);
            content.addButton(new Button[]{standing, sitting, crouching, swimming, sleeping, dying});
        }).setButton(18, MenuItems.toMain(player)).setButton(8, nudgeButton).build();
    }
}

