/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.internal.utils.ParameterizedSupplier;
import io.github.mqzen.menus.misc.button.Button;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class ActionRegistry {
    private static final boolean[] DEFAULT_SETTINGS = new boolean[]{true, true, true};
    private final Map<String, Class<? extends Action>> idToClass = new HashMap<String, Class<? extends Action>>();
    private final Map<Class<? extends Action>, ParameterizedSupplier<Button, Player>> classToButton = new HashMap<Class<? extends Action>, ParameterizedSupplier<Button, Player>>();
    private final Map<Class<? extends Action>, boolean[]> classToSettings = new HashMap<Class<? extends Action>, boolean[]>();

    public void register(String id, Class<? extends Action> clazz, ParameterizedSupplier<Button, Player> button, boolean canEdit, boolean canDuplicate, boolean canDelay) {
        this.register(id, clazz, button, new boolean[]{canEdit, canDuplicate, canDelay});
    }

    public void register(String id, Class<? extends Action> clazz, ParameterizedSupplier<Button, Player> button) {
        this.register(id, clazz, button, DEFAULT_SETTINGS);
    }

    private void register(String id, Class<? extends Action> clazz, ParameterizedSupplier<Button, Player> button, boolean[] settings) {
        this.idToClass.put(id, clazz);
        this.classToButton.put(clazz, button);
        this.classToSettings.put(clazz, settings);
    }

    public boolean canEdit(Class<? extends Action> clazz) {
        if (this.classToSettings.containsKey(clazz)) {
            return this.classToSettings.get(clazz)[0];
        }
        throw new IllegalStateException("The class " + clazz.getSimpleName() + " has not been registered.");
    }

    public boolean canEdit(String id) {
        if (this.idToClass.containsKey(id)) {
            return this.canEdit(this.idToClass.get(id));
        }
        throw new IllegalStateException("The action " + id + " has not been registered.");
    }

    public boolean canDuplicate(Class<? extends Action> clazz) {
        if (this.classToSettings.containsKey(clazz)) {
            return this.classToSettings.get(clazz)[1];
        }
        throw new IllegalStateException("The class " + clazz.getSimpleName() + " has not been registered.");
    }

    public boolean canDuplicate(String id) {
        if (this.idToClass.containsKey(id)) {
            return this.canDuplicate(this.idToClass.get(id));
        }
        throw new IllegalStateException("The action " + id + " has not been registered.");
    }

    public boolean canDelay(Class<? extends Action> clazz) {
        if (this.classToSettings.containsKey(clazz)) {
            return this.classToSettings.get(clazz)[1];
        }
        throw new IllegalStateException("The class " + clazz.getSimpleName() + " has not been registered.");
    }

    public boolean canDelay(String id) {
        if (this.idToClass.containsKey(id)) {
            return this.canDelay(this.idToClass.get(id));
        }
        throw new IllegalStateException("The action " + id + " has not been registered.");
    }

    public Button getButton(Class<? extends Action> clazz, Player player) {
        if (this.classToButton.containsKey(clazz)) {
            return this.classToButton.get(clazz).get(player);
        }
        throw new IllegalStateException("The class " + clazz.getSimpleName() + " has not been registered.");
    }

    public Button getButton(String id, Player player) {
        if (this.idToClass.containsKey(id)) {
            return this.getButton(this.idToClass.get(id), player);
        }
        throw new IllegalStateException("The action " + id + " has not been registered.");
    }

    public Collection<ParameterizedSupplier<Button, Player>> getButtons() {
        return this.classToButton.values();
    }

    public Collection<Button> getButtons(Player locale) {
        return this.classToButton.values().stream().map(button -> (Button)button.get(locale)).toList();
    }

    public Class<? extends Action> getActionClass(String id) {
        return this.idToClass.get(id);
    }
}

