/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.Scanner;
import lombok.Generated;

public class AutoUpdater {
    private final CustomNPCs plugin;
    private String newestVersion = "UNKNOWN";

    public AutoUpdater(CustomNPCs plugin) {
        this.plugin = plugin;
    }

    public boolean checkForUpdates() {
        try {
            String remoteVersion = this.getRemoteVersion();
            boolean updateAvailable = this.needUpdate(this.plugin.getPluginMeta().getVersion(), remoteVersion);
            if (updateAvailable) {
                this.plugin.getLogger().warning("A new version (" + remoteVersion + ") is available!");
                this.newestVersion = remoteVersion;
                return true;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
        }
        return false;
    }

    private String getRemoteVersion() throws IOException {
        String API_URL = "https://api.github.com/repos/foxikle/customnpcs/releases/latest";
        URL apiUrl = new URL(API_URL);
        HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
        try (InputStream responseStream = connection.getInputStream();){
            JsonObject releaseInfo;
            Scanner scanner;
            block13: {
                scanner = new Scanner(responseStream);
                try {
                    String responseBody = scanner.useDelimiter("\\A").next();
                    JsonParser jsonParser = new JsonParser();
                    releaseInfo = jsonParser.parse(responseBody).getAsJsonObject();
                    if (!this.isPreRelease(releaseInfo)) break block13;
                    String string = "";
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String string = releaseInfo.get("tag_name").getAsString().replace("v", "");
            scanner.close();
            return string;
        }
    }

    private boolean isPreRelease(JsonObject releaseInfo) {
        return releaseInfo.has("prerelease") && releaseInfo.get("prerelease").getAsBoolean();
    }

    private boolean needUpdate(String current, String remote) {
        if (Objects.equals(remote, "")) {
            return false;
        }
        String[] currentParts = current.split("\\-")[0].split("\\.");
        String[] remoteParts = remote.split("\\-")[0].split("\\.");
        int maxLength = Math.max(currentParts.length, remoteParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int remoteVersion;
            int currentVersion = i < currentParts.length ? AutoUpdater.getVersionPart(currentParts[i]) : 0;
            int n = remoteVersion = i < remoteParts.length ? AutoUpdater.getVersionPart(remoteParts[i]) : 0;
            if (currentVersion < remoteVersion) {
                return true;
            }
            if (currentVersion <= remoteVersion) continue;
            return false;
        }
        return false;
    }

    private static int getVersionPart(String versionPart) {
        try {
            return Integer.parseInt(versionPart);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Generated
    public String getNewestVersion() {
        return this.newestVersion;
    }
}

