/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.utils.ComponentWrapper;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;

public class Msg {
    public static Component translate(Locale locale, String key, Object ... args) {
        return Msg.format(Msg.translatedString(locale, key, args));
    }

    public static String translatedString(Locale locale, String key, Object ... args) {
        Object[] translatedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (object instanceof ComponentLike) {
                ComponentLike like = (ComponentLike)object;
                translatedArgs[i] = Msg.minimessage(like.asComponent());
                continue;
            }
            object = args[i];
            if (object instanceof String) {
                String string = (String)object;
                translatedArgs[i] = string;
                continue;
            }
            translatedArgs[i] = args[i];
        }
        MessageFormat format = GlobalTranslator.translator().translate(key, locale);
        if (format == null) {
            CustomNPCs.getInstance().getLogger().warning("Could not translate " + key + " to " + String.valueOf(locale));
            return key;
        }
        StringBuffer buffer = format.format(translatedArgs, new StringBuffer(), new FieldPosition(0));
        return buffer.toString();
    }

    public static Component[] lore(Locale locale, String key, Object ... args) {
        return (Component[])ComponentWrapper.wrap(Msg.translate(locale, key, args), 37).toArray(Component[]::new);
    }

    public static Component[] vlore(Locale locale, String key, int width, Object ... args) {
        return (Component[])ComponentWrapper.wrap(Msg.translate(locale, key, args), width).toArray(Component[]::new);
    }

    public static Component format(String str) {
        return CustomNPCs.getInstance().getMiniMessage().deserialize((Object)str).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE).colorIfAbsent((TextColor)NamedTextColor.WHITE);
    }

    public static String minimessage(Component component) {
        return (String)CustomNPCs.getInstance().getMiniMessage().serialize(component);
    }

    public static String plainText(Component comp) {
        return PlainTextComponentSerializer.plainText().serialize(comp);
    }
}

