/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.internal.utils;

import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;
import org.mineskin.ClientBuilder;
import org.mineskin.JsoupRequestHandler;
import org.mineskin.MineSkinClient;
import org.mineskin.data.JobInfo;
import org.mineskin.data.SkinInfo;
import org.mineskin.request.GenerateRequest;

public class SkinUtils {
    public static MineSkinClient MINESKIN_CLIENT;

    public static void setup(@Nullable String key, @Nullable String url) {
        ClientBuilder builder = MineSkinClient.builder().requestHandler(JsoupRequestHandler::new);
        if ((key == null || key.isEmpty()) && (url == null || url.isEmpty())) {
            builder.userAgent("Default-CustomNPCS/v1.7.4").baseUrl("https://mineskin.foxikle.dev");
        } else if (url == null || url.isEmpty()) {
            builder.userAgent("UserKey-CustomNPCS/v1.7.4").apiKey(key);
        } else {
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            builder.userAgent("UserProxy-CustomNPCs/v1.7.4").baseUrl(url);
        }
        MINESKIN_CLIENT = builder.build();
    }

    public static CompletableFuture<SkinInfo> fetch(GenerateRequest request) {
        return ((CompletableFuture)MINESKIN_CLIENT.queue().submit(request).thenCompose(queueResponse -> {
            JobInfo job = queueResponse.getJob();
            return job.waitForCompletion(MINESKIN_CLIENT);
        })).thenCompose(jobReference -> jobReference.getOrLoadSkin(MINESKIN_CLIENT));
    }
}

