/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.conditions;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.foxikle.customnpcs.actions.ActionType;
import dev.foxikle.customnpcs.actions.LegacyAction;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.actions.conditions.ConditionalTypeAdapter;
import java.io.IOException;
import java.util.ArrayList;

public class ActionAdapter
extends TypeAdapter<LegacyAction> {
    public void write(JsonWriter out, LegacyAction value) throws IOException {
        out.beginObject();
        out.name("actionType").value(value.getActionType().toString());
        out.name("args");
        out.beginArray();
        for (String s : value.getArgs()) {
            out.value(s);
        }
        out.endArray();
        out.name("delay").value((long)value.getDelay());
        out.name("mode").value(value.getMode().name());
        out.name("conditionals");
        out.beginArray();
        for (Condition c : value.getConditionals()) {
            out.value(c.toJson());
        }
        out.endArray();
        out.endObject();
        out.close();
    }

    public LegacyAction read(JsonReader in) throws IOException {
        in.beginObject();
        ActionType actionType = null;
        ArrayList<String> args = new ArrayList<String>();
        int delay = 0;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Condition.SelectionMode selectionMode = null;
        block17: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "actionType": 
                case "subCommand": {
                    actionType = ActionType.valueOf(in.nextString());
                    continue block17;
                }
                case "args": {
                    in.beginArray();
                    while (in.hasNext()) {
                        args.add(in.nextString());
                    }
                    in.endArray();
                    continue block17;
                }
                case "delay": {
                    delay = in.nextInt();
                    continue block17;
                }
                case "mode": {
                    selectionMode = Condition.SelectionMode.valueOf(in.nextString());
                    continue block17;
                }
                case "conditionals": {
                    in.beginArray();
                    while (in.hasNext()) {
                        try {
                            conditions.add(Condition.of(in.nextString()));
                        }
                        catch (JsonSyntaxException | IllegalStateException ignored) {
                            ConditionalTypeAdapter conditionalTypeAdapter = new ConditionalTypeAdapter();
                            conditions.add(conditionalTypeAdapter.read(in));
                        }
                    }
                    in.endArray();
                    continue block17;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return new LegacyAction(actionType, args, delay, selectionMode, conditions);
    }
}

