/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.conditions;

import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import org.bukkit.entity.Player;

public class NumericCondition
implements Condition {
    private final Condition.Type type = Condition.Type.NUMERIC;
    private Condition.Comparator comparator;
    private Condition.Value value;
    private double target;

    public NumericCondition(Condition.Comparator comparator, Condition.Value value, double target) {
        this.comparator = comparator;
        this.value = value;
        this.target = target;
    }

    @Override
    public boolean compute(Player player) {
        double value = 0.0;
        switch (this.value) {
            case X_COORD: {
                value = player.getLocation().x();
                break;
            }
            case Y_COORD: {
                value = player.getLocation().y();
                break;
            }
            case Z_COORD: {
                value = player.getLocation().z();
                break;
            }
            case EXP_LEVELS: {
                value = player.getLevel();
                break;
            }
            case EXP_POINTS: {
                value = player.getExp();
            }
        }
        switch (this.comparator) {
            case EQUAL_TO: {
                return value == this.target;
            }
            case NOT_EQUAL_TO: {
                return value != this.target;
            }
            case LESS_THAN: {
                return value < this.target;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return value <= this.target;
            }
            case GREATER_THAN: {
                return value > this.target;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return value >= this.target;
            }
        }
        return false;
    }

    @Override
    public String toJson() {
        return CustomNPCs.getGson().toJson((Object)this);
    }

    public static NumericCondition of(String data) {
        return (NumericCondition)CustomNPCs.getGson().fromJson(data, NumericCondition.class);
    }

    @Override
    public Condition.Type getType() {
        return this.type;
    }

    @Override
    public void setComparator(Condition.Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public void setValue(Condition.Value value) {
        this.value = value;
    }

    @Override
    public void setTargetValue(String targetValue) {
        this.target = Double.parseDouble(targetValue);
    }

    @Override
    public Condition.Value getValue() {
        return this.value;
    }

    @Override
    public String getTarget() {
        return String.valueOf(this.target);
    }

    @Override
    public Condition.Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public Condition clone() {
        try {
            return (NumericCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new NumericCondition(this.comparator, this.value, this.target);
        }
    }
}

