/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.runnables.ActionbarRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ActionBar
extends Action {
    private String rawMessage;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public ActionBar(String rawMessage, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.rawMessage = rawMessage;
    }

    public ActionBar(String rawMessage, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.rawMessage = rawMessage;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.IRON_INGOT).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.actionbar", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.actionbar.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            ActionBar actionImpl = new ActionBar("", 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(ActionBar.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + ActionBar.class.getName());
        }
        String rawMessage = ActionBar.parseString(serialized, "raw");
        Action.ParseResult pr = ActionBar.parseBase(serialized);
        ActionBar message = new ActionBar(rawMessage, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public Menu getMenu() {
        return new ActionbarCustomizer(this);
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.IRON_INGOT).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.actionbar", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.translate(player.locale(), "customnpcs.favicons.preview", Msg.format(this.getRawMessage())), Msg.format((String)(this.getRawMessage().isEmpty() ? "<dark_gray><i>" + Msg.translatedString(player.locale(), "customnpcs.messages.empty_string", new Object[0]) : this.getRawMessage())), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        player.sendActionBar(Msg.format(CustomNPCs.getInstance().papi ? PlaceholderAPI.setPlaceholders((Player)player, (String)this.rawMessage) : this.rawMessage));
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        return this.generateSerializedString("ActionBar", Map.of("raw", this.rawMessage));
    }

    @Override
    public Action clone() {
        return new ActionBar(this.rawMessage, this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Generated
    public String getRawMessage() {
        return this.rawMessage;
    }

    @Generated
    public void setRawMessage(String rawMessage) {
        this.rawMessage = rawMessage;
    }

    public class ActionbarCustomizer
    implements Menu {
        private final ActionBar actionBar;

        public ActionbarCustomizer(ActionBar actionBar) {
            this.actionBar = actionBar;
        }

        public String getName() {
            return "ACTIONBAR_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            return MenuUtils.actionBase(this.actionBar, player).setButton(22, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.PAPER).setDisplay((Object)Msg.translate(player.locale(), (String)(ActionBar.this.getRawMessage().isEmpty() ? "<dark_gray><i>" + Msg.translatedString(player.locale(), "customnpcs.messages.empty_string", new Object[0]) : ActionBar.this.getRawMessage()), new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                CustomNPCs plugin = CustomNPCs.getInstance();
                player.closeInventory();
                plugin.wait(player, WaitingType.ACTIONBAR);
                new ActionbarRunnable(player, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
            }))).build();
        }
    }
}

