/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class GiveEffect
extends Action {
    private static final List<Field> fields = Stream.of(PotionEffectType.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers())).toList();
    boolean particles;
    private String effect;
    private int duration;
    private int amplifier;

    public GiveEffect(String effect, int duration, int amplifier, boolean particles, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.particles = particles;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public GiveEffect(String effect, int duration, int amplifier, boolean particles, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.particles = particles;
    }

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BREWING_STAND).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.give_effect", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.give_effect.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            GiveEffect actionImpl = new GiveEffect("SPEED", 100, 0, false, 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(GiveEffect.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + GiveEffect.class.getName());
        }
        String effect = GiveEffect.parseString(serialized, "effect");
        int duration = GiveEffect.parseInt(serialized, "duration");
        int amplifier = GiveEffect.parseInt(serialized, "amplifier");
        boolean particles = GiveEffect.parseBoolean(serialized, "particles");
        Action.ParseResult pr = GiveEffect.parseBase(serialized);
        GiveEffect message = new GiveEffect(effect, duration, amplifier, particles, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BREWING_STAND).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.give_effect", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.give_effect.effect", this.effect), Msg.translate(player.locale(), "customnpcs.favicons.give_effect.duration", this.duration), Msg.translate(player.locale(), "customnpcs.favicons.give_effect.amplifier", this.amplifier), Msg.translate(player.locale(), "customnpcs.favicons.give_effect.particles", this.particles), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        if (PotionEffectType.getByName((String)this.effect) == null) {
            throw new NullPointerException("Effect " + this.effect + " does not exist? Please tell @foxikle on discord how you managed this.");
        }
        player.addPotionEffect(new PotionEffect(Objects.requireNonNull(PotionEffectType.getByName((String)this.effect)), this.duration, this.amplifier, true, !this.particles));
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("effect", this.effect);
        params.put("duration", this.duration);
        params.put("amplifier", this.amplifier);
        params.put("particles", this.particles);
        return this.generateSerializedString("GiveEffect", params);
    }

    @Override
    public Action clone() {
        return new GiveEffect(this.getEffect(), this.getDuration(), this.getAmplifier(), this.isParticles(), this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Override
    public Menu getMenu() {
        return new GiveEffectCustomizer(this);
    }

    @Generated
    public boolean isParticles() {
        return this.particles;
    }

    @Generated
    public String getEffect() {
        return this.effect;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public int getAmplifier() {
        return this.amplifier;
    }

    @Generated
    public void setParticles(boolean particles) {
        this.particles = particles;
    }

    @Generated
    public void setEffect(String effect) {
        this.effect = effect;
    }

    @Generated
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Generated
    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public static class GiveEffectCustomizer
    implements Menu {
        private final GiveEffect action;

        public GiveEffectCustomizer(GiveEffect action) {
            this.action = action;
        }

        public String getName() {
            return "GIVE_EFFECT_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            Object[] incLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.increment.description", new Object[0]);
            Object[] decLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.decrement.description", new Object[0]);
            Component[] displayLore = Msg.lore(player.locale(), "customnpcs.menus.action.title.display.lore", new Object[0]);
            return MenuUtils.actionBase(this.action, player).setButton(10, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.duration.increase", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    this.action.setDuration(this.action.getDuration() + 20);
                } else if (event.isLeftClick()) {
                    this.action.setDuration(this.action.getDuration() + 1);
                } else if (event.isRightClick()) {
                    this.action.setDuration(this.action.getDuration() + 5);
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.duration", this.action.getDuration()), displayLore)));
            }))).setButton(12, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier.increase", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (this.action.getAmplifier() == 255) {
                    player.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier_over_255", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setAmplifier(Math.min(255, this.action.getAmplifier() + 20));
                } else if (event.isLeftClick()) {
                    this.action.setAmplifier(Math.min(255, this.action.getAmplifier() + 1));
                } else if (event.isRightClick()) {
                    this.action.setAmplifier(Math.min(255, this.action.getAmplifier() + 5));
                }
                menuView.updateButton(21, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier", this.action.getAmplifier()), displayLore)));
            }))).setButton(19, Button.empty((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.duration", this.action.getDuration()), displayLore))).setButton(21, Button.empty((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier", this.action.getAmplifier()), displayLore))).setButton(28, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.duration.decrease", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                Player p = (Player)event.getWhoClicked();
                if (this.action.getDuration() == 1) {
                    p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.duration_under_1", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setDuration(Math.max(1, this.action.getDuration() - 20));
                } else if (event.isLeftClick()) {
                    this.action.setDuration(Math.max(1, this.action.getDuration() - 1));
                } else if (event.isRightClick()) {
                    this.action.setDuration(Math.max(1, this.action.getDuration() - 5));
                }
                menuView.updateButton(19, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.duration", this.action.getDuration()), displayLore)));
            }))).setButton(30, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier.decrease", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                Player p = (Player)event.getWhoClicked();
                if (this.action.getAmplifier() == 0) {
                    p.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier_under_0", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    this.action.setAmplifier(Math.max(0, this.action.getAmplifier() - 20));
                } else if (event.isLeftClick()) {
                    this.action.setAmplifier(Math.max(0, this.action.getAmplifier() - 1));
                } else if (event.isRightClick()) {
                    this.action.setAmplifier(Math.max(0, this.action.getAmplifier() - 5));
                }
                menuView.updateButton(21, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.amplifier", this.action.getAmplifier()), displayLore)));
            }))).setButton(23, this.generateParticles(player)).setButton(25, this.generateToggleEffect(player)).build();
        }

        private Button generateParticles(Player player) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)(this.action.particles ? Material.GREEN_CANDLE : Material.RED_CANDLE)).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.particles", this.action.particles))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.action.setParticles(!this.action.isParticles());
                menuView.updateButton(23, button -> button.setItem(this.generateParticles(player).getItem()));
            }));
        }

        private Button generateToggleEffect(Player player) {
            ArrayList lore = new ArrayList();
            fields.forEach(field -> {
                if (!Objects.equals(this.action.getEffect(), field.getName())) {
                    lore.add(Msg.format("<green>" + field.getName()));
                } else {
                    lore.add(Msg.format("<dark_aqua>\u25b8 " + field.getName()));
                }
            });
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.POTION).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_effect.effect", new Object[0]))).addFlags(ItemFlag.values())).setLore((Object[])lore.toArray(new Component[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                ArrayList effects = new ArrayList();
                fields.forEach(field -> effects.add(field.getName()));
                int index = effects.indexOf(this.action.getEffect());
                if (event.isLeftClick()) {
                    if (effects.size() > index + 1) {
                        this.action.setEffect((String)effects.get(index + 1));
                    } else {
                        this.action.setEffect((String)effects.get(0));
                    }
                } else if (event.isRightClick()) {
                    if (index == 0) {
                        this.action.setEffect((String)effects.get(effects.size() - 1));
                    } else {
                        this.action.setEffect((String)effects.get(index - 1));
                    }
                }
                menuView.updateButton(25, button -> button.setItem(this.generateToggleEffect(player).getItem()));
            }));
        }
    }
}

