/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.utils.Msg;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class GiveXP
extends Action {
    private int amount;
    private boolean levels;

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.EXPERIENCE_BOTTLE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.give_xp", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.give_xp.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            GiveXP actionImpl = new GiveXP(1, true, 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public GiveXP(int amount, boolean levels, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.levels = levels;
        this.amount = amount;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public GiveXP(int amount, boolean levels, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.levels = levels;
        this.amount = amount;
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(GiveXP.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + GiveXP.class.getName());
        }
        int amount = GiveXP.parseInt(serialized, "amount");
        boolean levels = GiveXP.parseBoolean(serialized, "levels");
        Action.ParseResult pr = GiveXP.parseBase(serialized);
        GiveXP message = new GiveXP(amount, levels, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.EXPERIENCE_BOTTLE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.give_xp", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.xp", this.amount), Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.awarding", this.levels ? Msg.translatedString(player.locale(), "customnpcs.menus.action.xp.levels", new Object[0]) : Msg.translatedString(player.locale(), "customnpcs.menus.action.xp.points", new Object[0])), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        if (this.levels) {
            player.giveExpLevels(this.amount);
        } else {
            player.giveExp(this.amount, true);
        }
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        return this.generateSerializedString("GiveXP", Map.of("amount", this.amount, "levels", this.levels));
    }

    @Override
    public Action clone() {
        return new GiveXP(this.amount, this.levels, this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Override
    public Menu getMenu() {
        return new GiveXPCustomizer(this);
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public boolean isLevels() {
        return this.levels;
    }

    @Generated
    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Generated
    public void setLevels(boolean levels) {
        this.levels = levels;
    }

    public class GiveXPCustomizer
    implements Menu {
        private final GiveXP action;

        public GiveXPCustomizer(GiveXP action) {
            this.action = action;
        }

        public String getName() {
            return "GIVE_XP_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            Object[] incLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.increment.description", new Object[0]);
            Object[] decLore = Msg.lore(player.locale(), "customnpcs.menus.action_customizer.delay.decrement.description", new Object[0]);
            return MenuUtils.actionBase(this.action, player).setButton(11, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.increase", new Object[0]))).setLore(incLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (event.isShiftClick()) {
                    GiveXP.this.setAmount(GiveXP.this.getAmount() + 20);
                } else if (event.isLeftClick()) {
                    GiveXP.this.setAmount(GiveXP.this.getAmount() + 1);
                } else if (event.isRightClick()) {
                    GiveXP.this.setAmount(GiveXP.this.getAmount() + 5);
                }
                menuView.updateButton(20, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.xp", GiveXP.this.getAmount()), new Component[0])));
            }))).setButton(20, MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.xp", GiveXP.this.getAmount()), new Component[0])).setButton(29, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.decrease", new Object[0]))).setLore(decLore)).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                if (GiveXP.this.getAmount() == 1) {
                    event.getWhoClicked().sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.xp_less_one", new Object[0]));
                    return;
                }
                if (event.isShiftClick()) {
                    GiveXP.this.setAmount(Math.max(1, GiveXP.this.getAmount() - 20));
                } else if (event.isLeftClick()) {
                    GiveXP.this.setAmount(Math.max(1, GiveXP.this.getAmount() - 1));
                } else if (event.isRightClick()) {
                    GiveXP.this.setAmount(Math.max(1, GiveXP.this.getAmount() - 5));
                }
                menuView.updateButton(20, button -> button.setItem(MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.xp", GiveXP.this.getAmount()), new Component[0])));
            }))).setButton(24, this.toggle(player)).build();
        }

        private Button toggle(Player player) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)ItemBuilder.modern((Material)(GiveXP.this.isLevels() ? Material.GREEN_CANDLE : Material.RED_CANDLE)).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.give_xp.awarding", GiveXP.this.isLevels() ? Msg.translate(player.locale(), "customnpcs.menus.action.xp.levels", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.action.xp.points", new Object[0])))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                Player p = (Player)event.getWhoClicked();
                p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                GiveXP.this.setLevels(!GiveXP.this.isLevels());
                menuView.updateButton(24, button -> button.setItem(this.toggle(p).getItem()));
            }));
        }
    }
}

