/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.runnables.SoundRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.Utils;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlaySound
extends Action {
    float volume;
    float pitch;
    private String sound;

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BELL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.sound", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.sound.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            event.setCancelled(true);
            Player p = (Player)event.getWhoClicked();
            p.playSound(Sound.sound((Key)Key.key((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
            PlaySound actionImpl = new PlaySound("minecraft:ui.button.click", 1.0f, 1.0f, 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public PlaySound(String sound, float volume, float pitch, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public PlaySound(String sound, float volume, float pitch, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(PlaySound.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + PlaySound.class.getName());
        }
        String sound = PlaySound.parseString(serialized, "sound");
        float volume = PlaySound.parseFloat(serialized, "volume");
        float pitch = PlaySound.parseFloat(serialized, "pitch");
        Action.ParseResult pr = PlaySound.parseBase(serialized);
        PlaySound message = new PlaySound(sound, volume, pitch, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(message));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.BELL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.sound", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.menus.action.sound.sound", this.sound), Msg.translate(player.locale(), "customnpcs.menus.action.sound.volume", Utils.DECIMAL_FORMAT.format(this.volume)), Msg.translate(player.locale(), "customnpcs.menus.action.sound.pitch", Utils.DECIMAL_FORMAT.format(this.pitch)), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        Sound sound = Sound.sound((Key)Key.key((String)this.sound), (Sound.Source)Sound.Source.MASTER, (float)this.volume, (float)this.pitch);
        player.playSound(sound);
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        return this.generateSerializedString("PlaySound", Map.of("sound", this.sound, "volume", Float.valueOf(this.volume), "pitch", Float.valueOf(this.pitch)));
    }

    @Override
    public Action clone() {
        return new PlaySound(this.sound, this.volume, this.pitch, this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Override
    public Menu getMenu() {
        return new PlaySoundCustomizer(this);
    }

    @Generated
    public float getVolume() {
        return this.volume;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public String getSound() {
        return this.sound;
    }

    @Generated
    public void setVolume(float volume) {
        this.volume = volume;
    }

    @Generated
    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Generated
    public void setSound(String sound) {
        this.sound = sound;
    }

    public class PlaySoundCustomizer
    implements Menu {
        private final PlaySound action;

        public PlaySoundCustomizer(PlaySound action) {
            this.action = action;
        }

        public String getName() {
            return "PLAY_SOUND_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            Component incLore = Msg.translate(player.locale(), "customnpcs.menus.action.sound.increase", new Object[0]);
            Component decLore = Msg.translate(player.locale(), "customnpcs.menus.action.sound.decrease", new Object[0]);
            return MenuUtils.actionBase(this.action, player).setButton(19, this.pitch(player)).setButton(21, this.volume(player)).setButton(10, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.sound.increase_pitch", new Object[0]))).setLore((Object[])new Component[]{incLore})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound(Sound.sound((Key)Key.key((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
                PlaySound.this.setPitch(PlaySound.this.getPitch() + 0.1f);
                menuView.replaceButton(19, this.pitch(player));
            }))).setButton(12, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.LIME_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.sound.increase_volume", new Object[0]))).setLore((Object[])new Component[]{incLore})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound(Sound.sound((Key)Key.key((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
                PlaySound.this.setVolume(PlaySound.this.getVolume() + 0.1f);
                menuView.replaceButton(21, this.volume(player));
            }))).setButton(28, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.sound.decrease_pitch", new Object[0]))).setLore((Object[])new Component[]{decLore})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound(Sound.sound((Key)Key.key((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
                Player p1 = (Player)event.getWhoClicked();
                if ((double)PlaySound.this.getPitch() - 0.1 <= 0.0) {
                    p1.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.sound.invalid_pitch", new Object[0]));
                } else {
                    PlaySound.this.setPitch(PlaySound.this.getPitch() - 0.1f);
                }
                menuView.replaceButton(19, this.pitch(player));
            }))).setButton(30, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.RED_DYE).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.sound.decrease_volume", new Object[0]))).setLore((Object[])new Component[]{decLore})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound(Sound.sound((Key)Key.key((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
                Player p1 = (Player)event.getWhoClicked();
                if ((double)PlaySound.this.getVolume() - 0.1 <= 0.0) {
                    p1.sendMessage(Msg.translate(player.locale(), "customnpcs.menus.action.sound.invalid_volume", new Object[0]));
                } else {
                    PlaySound.this.setVolume(PlaySound.this.getVolume() - 0.1f);
                    menuView.replaceButton(21, this.volume(player));
                }
            }))).setButton(24, Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.OAK_SIGN).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.menus.action.sound.sound", PlaySound.this.getSound()))).setLore((Object[])new Component[]{Component.empty(), Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound(Sound.sound((Key)Key.key((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f));
                Player p = (Player)event.getWhoClicked();
                CustomNPCs plugin = CustomNPCs.getInstance();
                p.closeInventory();
                plugin.wait(p, WaitingType.SOUND);
                new SoundRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
            }))).build();
        }

        private Button volume(Player player) {
            return Button.clickable((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.sound.volume", Utils.DECIMAL_FORMAT.format(PlaySound.this.getVolume())), new Component[0]), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> event.setCancelled(true)));
        }

        private Button pitch(Player player) {
            return Button.clickable((ItemStack)MenuItems.genericDisplay(Msg.translate(player.locale(), "customnpcs.menus.action.sound.pitch", Utils.DECIMAL_FORMAT.format(PlaySound.this.getPitch())), new Component[0]), (ButtonClickAction)ButtonClickAction.plain((menu, event) -> event.setCancelled(true)));
        }
    }
}

