/*
 * Decompiled with CFR 0.152.
 */
package dev.foxikle.customnpcs.actions.defaultImpl;

import dev.foxikle.customnpcs.actions.Action;
import dev.foxikle.customnpcs.actions.conditions.Condition;
import dev.foxikle.customnpcs.internal.CustomNPCs;
import dev.foxikle.customnpcs.internal.interfaces.InternalNpc;
import dev.foxikle.customnpcs.internal.menu.MenuItems;
import dev.foxikle.customnpcs.internal.menu.MenuUtils;
import dev.foxikle.customnpcs.internal.runnables.CommandRunnable;
import dev.foxikle.customnpcs.internal.utils.Msg;
import dev.foxikle.customnpcs.internal.utils.Utils;
import dev.foxikle.customnpcs.internal.utils.WaitingType;
import io.github.mqzen.menus.base.Content;
import io.github.mqzen.menus.base.Menu;
import io.github.mqzen.menus.misc.Capacity;
import io.github.mqzen.menus.misc.DataRegistry;
import io.github.mqzen.menus.misc.button.Button;
import io.github.mqzen.menus.misc.button.actions.ButtonClickAction;
import io.github.mqzen.menus.misc.itembuilder.ComponentItemBuilder;
import io.github.mqzen.menus.misc.itembuilder.ItemBuilder;
import io.github.mqzen.menus.titles.MenuTitle;
import io.github.mqzen.menus.titles.MenuTitles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class RunCommand
extends Action {
    private String command;
    private boolean asConsole;

    public static Button creationButton(Player player) {
        return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ANVIL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.command", new Object[0]))).setLore((Object[])Msg.lore(player.locale(), "customnpcs.favicons.command.description", new Object[0]))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
            Player p = (Player)event.getWhoClicked();
            event.setCancelled(true);
            p.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            RunCommand actionImpl = new RunCommand("say hi", false, 0, Condition.SelectionMode.ONE, new ArrayList<Condition>(), 0);
            CustomNPCs.getInstance().editingActions.put(p.getUniqueId(), actionImpl);
            menuView.getAPI().openMenu(p, actionImpl.getMenu());
        }));
    }

    public RunCommand(String rawCommand, boolean asConsole, int delay, Condition.SelectionMode mode, List<Condition> conditionals, int cooldown) {
        super(delay, mode, conditionals, cooldown);
        this.command = rawCommand;
        this.asConsole = asConsole;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.9")
    public RunCommand(String rawCommand, boolean asConsole, int delay, Condition.SelectionMode mode, List<Condition> conditionals) {
        super(delay, mode, conditionals, 0);
        this.command = rawCommand;
        this.asConsole = asConsole;
    }

    public static <T extends Action> T deserialize(String serialized, Class<T> clazz) {
        if (!clazz.equals(RunCommand.class)) {
            throw new IllegalArgumentException("Cannot deserialize " + clazz.getName() + " to " + RunCommand.class.getName());
        }
        String raw = RunCommand.parseString(serialized, "raw");
        boolean asConsole = RunCommand.parseBoolean(serialized, "asConsole");
        Action.ParseResult pr = RunCommand.parseBase(serialized);
        RunCommand command = new RunCommand(raw, asConsole, pr.delay(), pr.mode(), pr.conditions(), pr.cooldown());
        return (T)((Action)clazz.cast(command));
    }

    @Override
    public ItemStack getFavicon(Player player) {
        return ((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ANVIL).setDisplay((Object)Msg.translate(player.locale(), "customnpcs.favicons.command", new Object[0]))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.favicons.delay", this.getDelay()), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.command.syntax", this.command), Msg.translate(player.locale(), "customnpcs.favicons.command.as_console", this.asConsole), Msg.format(""), Msg.translate(player.locale(), "customnpcs.favicons.edit", new Object[0]), Msg.translate(player.locale(), "customnpcs.favicons.remove", new Object[0])})).build();
    }

    @Override
    public Menu getMenu() {
        return new RunCommandCustomizer(this);
    }

    @Override
    public void perform(InternalNpc npc, Menu menu, Player player) {
        if (!this.processConditions(player)) {
            return;
        }
        String command = this.command;
        if (CustomNPCs.getInstance().papi) {
            command = PlaceholderAPI.setPlaceholders((Player)player, (String)this.command);
        }
        Bukkit.dispatchCommand((CommandSender)(this.asConsole ? Bukkit.getConsoleSender() : player), (String)command);
        this.activateCooldown(player.getUniqueId());
    }

    @Override
    public String serialize() {
        return this.generateSerializedString("RunCommand", Map.of("raw", this.command, "asConsole", this.asConsole));
    }

    @Override
    public Action clone() {
        return new RunCommand(this.command, this.asConsole, this.getDelay(), this.getMode(), new ArrayList<Condition>(this.getConditions()), this.getCooldown());
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public boolean isAsConsole() {
        return this.asConsole;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public void setAsConsole(boolean asConsole) {
        this.asConsole = asConsole;
    }

    public class RunCommandCustomizer
    implements Menu {
        private final RunCommand action;

        public RunCommandCustomizer(RunCommand action) {
            this.action = action;
        }

        public String getName() {
            return "RUN_COMMAND_CUSTOMIZER";
        }

        @NotNull
        public MenuTitle getTitle(DataRegistry dataRegistry, Player player) {
            return MenuTitles.createModern((Component)Msg.translate(player.locale(), "customnpcs.menus.action_customizer.title", new Object[0]));
        }

        @NotNull
        public Capacity getCapacity(DataRegistry dataRegistry, Player player) {
            return Capacity.ofRows((int)5);
        }

        @NotNull
        public Content getContent(DataRegistry dataRegistry, Player player, Capacity capacity) {
            return MenuUtils.actionBase(this.action, player).setButton(player.hasPermission("customnpcs.run_command.enable_console") ? 21 : 22, this.setCommand(player)).setButton(23, this.toggle(player)).build();
        }

        private Button toggle(Player player) {
            if (!player.hasPermission("customnpcs.run_command.enable_console")) {
                return MenuItems.MENU_GLASS;
            }
            ArrayList<Component> lore = new ArrayList<Component>();
            if (RunCommand.this.isAsConsole()) {
                lore.addAll(Utils.list(Msg.lore(player.locale(), "customnpcs.menus.action.command.as_console.warning", new Object[0])));
            }
            lore.add(Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0]));
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)(RunCommand.this.isAsConsole() ? Material.RED_CANDLE : Material.GREEN_CANDLE)).setLore((Object[])lore.toArray(new Component[0]))).setDisplay((Object)(RunCommand.this.isAsConsole() ? Msg.translate(player.locale(), "customnpcs.menus.action.command.as_console.true", new Object[0]) : Msg.translate(player.locale(), "customnpcs.menus.action.command.as_console.false", new Object[0])))).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                Player p = (Player)event.getWhoClicked();
                if (!p.hasPermission("customnpcs.run_command.enable_console")) {
                    p.sendMessage(Msg.translate(player.locale(), "customnpcs.commands.no_permission", new Object[0]));
                    return;
                }
                RunCommand.this.setAsConsole(!RunCommand.this.isAsConsole());
                menuView.updateButton(23, button -> button.setItem(this.toggle(p).getItem()));
            }));
        }

        private Button setCommand(Player player) {
            return Button.clickable((ItemStack)((ComponentItemBuilder)((ComponentItemBuilder)ItemBuilder.modern((Material)Material.ANVIL).setDisplay((Object)Component.text((String)("/" + RunCommand.this.getCommand())))).setLore((Object[])new Component[]{Msg.translate(player.locale(), "customnpcs.items.click_to_change", new Object[0])})).build(), (ButtonClickAction)ButtonClickAction.plain((menuView, event) -> {
                CustomNPCs plugin = CustomNPCs.getInstance();
                Player p = (Player)event.getWhoClicked();
                p.closeInventory();
                plugin.wait(p, WaitingType.COMMAND);
                new CommandRunnable(p, plugin).runTaskTimer((Plugin)plugin, 0L, 10L);
                event.setCancelled(true);
                player.playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }));
        }
    }
}

